/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.testing;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import org.wikidata.wdtk.testing.MockStringContentFactory;
import org.wikidata.wdtk.util.CompressionType;
import org.wikidata.wdtk.util.WebResourceFetcher;

public class MockWebResourceFetcher
implements WebResourceFetcher {
    public final HashMap<String, byte[]> webResources = new HashMap();
    boolean returnFailingReaders;

    public void setReturnFailingReaders(boolean returnFailingReaders) {
        this.returnFailingReaders = returnFailingReaders;
    }

    public void setWebResourceContents(String url, String contents) throws IOException {
        this.setWebResourceContents(url, contents, CompressionType.NONE);
    }

    public void setWebResourceContents(String url, String contents, CompressionType compressionType) throws IOException {
        this.webResources.put(url, MockStringContentFactory.getBytesFromString(contents, compressionType));
    }

    public void setWebResourceContentsFromResource(String url, String resource, Class<?> resourceClass) throws IOException {
        this.setWebResourceContentsFromResource(url, resource, resourceClass, CompressionType.NONE);
    }

    public void setWebResourceContentsFromResource(String url, String resource, Class<?> resourceClass, CompressionType compressionType) throws IOException {
        URL resourceUrl = resourceClass.getResource(resource);
        String contents = MockStringContentFactory.getStringFromUrl(resourceUrl);
        this.setWebResourceContents(url, contents, compressionType);
    }

    public InputStream getInputStreamForUrl(String urlString) throws IOException {
        return this.getInputStreamForMockWebResource(urlString);
    }

    InputStream getInputStreamForMockWebResource(String urlString) throws IOException {
        if (!this.webResources.containsKey(urlString)) {
            throw new IOException("Inaccessible URL (not mocked): " + urlString);
        }
        if (this.returnFailingReaders) {
            return MockStringContentFactory.getFailingInputStream();
        }
        return MockStringContentFactory.newMockInputStream(this.webResources.get(urlString));
    }
}

