/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.util;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class Timer {
    public static final int RECORD_NONE = 0;
    public static final int RECORD_CPUTIME = 1;
    public static final int RECORD_WALLTIME = 2;
    public static final int RECORD_ALL = 3;
    static final ThreadMXBean tmxb = ManagementFactory.getThreadMXBean();
    static final ConcurrentHashMap<Timer, Timer> registeredTimers = new ConcurrentHashMap();
    final String name;
    final long threadId;
    final int todoFlags;
    long currentStartCpuTime = -1L;
    long currentStartWallTime = -1L;
    boolean isRunning = false;
    long totalCpuTime = 0L;
    long totalWallTime = 0L;
    int measurements = 0;
    int threadCount = 0;

    public Timer(String name, int todoFlags, long threadId) {
        this.name = name;
        this.todoFlags = todoFlags;
        this.threadId = threadId;
        if (!tmxb.isThreadCpuTimeEnabled()) {
            tmxb.setThreadCpuTimeEnabled(true);
        }
    }

    public Timer(String name, int todoFlags) {
        this(name, todoFlags, Thread.currentThread().getId());
    }

    public String getName() {
        return this.name;
    }

    public long getThreadId() {
        return this.threadId;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public long getTotalCpuTime() {
        return this.totalCpuTime;
    }

    public long getAvgCpuTime() {
        if (this.measurements > 0) {
            return this.totalCpuTime / (long)this.measurements;
        }
        return 0L;
    }

    public long getTotalWallTime() {
        return this.totalWallTime;
    }

    public long getAvgWallTime() {
        if (this.measurements > 0) {
            return this.totalWallTime / (long)this.measurements;
        }
        return 0L;
    }

    public synchronized void start() {
        this.currentStartCpuTime = (this.todoFlags & 1) != 0 ? Timer.getThreadCpuTime(this.threadId) : -1L;
        this.currentStartWallTime = (this.todoFlags & 2) != 0 ? System.nanoTime() : -1L;
        this.isRunning = true;
    }

    public synchronized void reset() {
        this.currentStartCpuTime = -1L;
        this.currentStartWallTime = -1L;
        this.totalCpuTime = 0L;
        this.totalWallTime = 0L;
        this.measurements = 0;
        this.isRunning = false;
        this.threadCount = 0;
    }

    public synchronized long stop() {
        long cpuTime;
        long totalTime = -1L;
        if ((this.todoFlags & 1) != 0 && this.currentStartCpuTime != -1L && (cpuTime = Timer.getThreadCpuTime(this.threadId)) != -1L) {
            totalTime = cpuTime - this.currentStartCpuTime;
            this.totalCpuTime += totalTime;
        }
        if ((this.todoFlags & 2) != 0 && this.currentStartWallTime != -1L) {
            long wallTime = System.nanoTime();
            this.totalWallTime += wallTime - this.currentStartWallTime;
        }
        if (this.isRunning) {
            ++this.measurements;
            this.isRunning = false;
        }
        this.currentStartWallTime = -1L;
        this.currentStartCpuTime = -1L;
        return totalTime;
    }

    public String toString() {
        String separator;
        String runningWarning = this.isRunning ? " [timer running!]" : "";
        Object timerLabel = this.threadId != 0L ? this.name + " (thread " + this.threadId + ")" : (this.threadCount > 1 ? this.name + " (over " + this.threadCount + " threads)" : this.name);
        if (this.todoFlags == 0) {
            return "Timer " + (String)timerLabel + " recorded " + this.measurements + " run(s); no times taken" + runningWarning;
        }
        StringBuilder labels = new StringBuilder();
        StringBuilder values = new StringBuilder();
        if ((this.todoFlags & 1) != 0 && this.threadId != 0L) {
            labels.append("CPU");
            values.append(this.totalCpuTime / 1000000L);
            separator = "/";
        } else {
            separator = "";
        }
        if ((this.todoFlags & 2) != 0) {
            labels.append(separator).append("Wall");
            values.append(separator).append(this.totalWallTime / 1000000L);
        }
        if ((this.todoFlags & 1) != 0 && this.threadId != 0L) {
            labels.append("/CPU avg");
            values.append("/").append((float)this.totalCpuTime / (float)this.measurements / 1000000.0f);
        }
        if ((this.todoFlags & 2) != 0) {
            labels.append("/Wall avg");
            values.append("/").append((float)this.totalWallTime / (float)this.measurements / 1000000.0f);
        }
        if (this.threadCount > 1) {
            if ((this.todoFlags & 1) != 0 && this.threadId != 0L) {
                labels.append("/CPU per thread");
                values.append("/").append((float)this.totalCpuTime / (float)this.threadCount / 1000000.0f);
            }
            if ((this.todoFlags & 2) != 0) {
                labels.append("/Wall per thread");
                values.append("/").append((float)this.totalWallTime / (float)this.threadCount / 1000000.0f);
            }
        }
        return "Time for " + (String)timerLabel + " for " + this.measurements + " run(s) " + labels + " (ms): " + values + runningWarning;
    }

    public static void startNamedTimer(String timerName) {
        Timer.getNamedTimer(timerName).start();
    }

    public static void startNamedTimer(String timerName, int todoFlags) {
        Timer.getNamedTimer(timerName, todoFlags).start();
    }

    public static void startNamedTimer(String timerName, int todoFlags, long threadId) {
        Timer.getNamedTimer(timerName, todoFlags, threadId).start();
    }

    public static long stopNamedTimer(String timerName) {
        return Timer.stopNamedTimer(timerName, 3, Thread.currentThread().getId());
    }

    public static long stopNamedTimer(String timerName, int todoFlags) {
        return Timer.stopNamedTimer(timerName, todoFlags, Thread.currentThread().getId());
    }

    public static long stopNamedTimer(String timerName, int todoFlags, long threadId) {
        Timer key = new Timer(timerName, todoFlags, threadId);
        if (registeredTimers.containsKey(key)) {
            return registeredTimers.get(key).stop();
        }
        return -1L;
    }

    public static void resetNamedTimer(String timerName) {
        Timer.getNamedTimer(timerName).reset();
    }

    public static void resetNamedTimer(String timerName, int todoFlags) {
        Timer.getNamedTimer(timerName, todoFlags).reset();
    }

    public static void resetNamedTimer(String timerName, int todoFlags, long threadId) {
        Timer.getNamedTimer(timerName, todoFlags, threadId).reset();
    }

    public static Timer getNamedTimer(String timerName) {
        return Timer.getNamedTimer(timerName, 3, Thread.currentThread().getId());
    }

    public static Timer getNamedTimer(String timerName, int todoFlags) {
        return Timer.getNamedTimer(timerName, todoFlags, Thread.currentThread().getId());
    }

    public static Timer getNamedTimer(String timerName, int todoFlags, long threadId) {
        Timer key = new Timer(timerName, todoFlags, threadId);
        registeredTimers.putIfAbsent(key, key);
        return registeredTimers.get(key);
    }

    public static Timer getNamedTotalTimer(String timerName) {
        long totalCpuTime = 0L;
        long totalSystemTime = 0L;
        int measurements = 0;
        int timerCount = 0;
        int todoFlags = 0;
        Timer previousTimer = null;
        for (Map.Entry<Timer, Timer> entry : registeredTimers.entrySet()) {
            if (!entry.getValue().name.equals(timerName)) continue;
            previousTimer = entry.getValue();
            ++timerCount;
            totalCpuTime += previousTimer.totalCpuTime;
            totalSystemTime += previousTimer.totalWallTime;
            measurements += previousTimer.measurements;
            todoFlags |= previousTimer.todoFlags;
        }
        if (timerCount == 1) {
            return previousTimer;
        }
        Timer result = new Timer(timerName, todoFlags, 0L);
        result.totalCpuTime = totalCpuTime;
        result.totalWallTime = totalSystemTime;
        result.measurements = measurements;
        result.threadCount = timerCount;
        return result;
    }

    public int hashCode() {
        return new HashCodeBuilder(997, 1013).append((Object)this.name).append(this.threadId).append(this.todoFlags).toHashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Timer)) {
            return false;
        }
        Timer other = (Timer)obj;
        return this.threadId == other.threadId && this.todoFlags == other.todoFlags && this.name.equals(other.name);
    }

    static long getThreadCpuTime(long threadId) {
        if (threadId == 0L) {
            return 0L;
        }
        return tmxb.getThreadCpuTime(threadId);
    }
}

