/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.wikibaseapi;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wikidata.wdtk.datamodel.helpers.Datamodel;
import org.wikidata.wdtk.datamodel.helpers.DatamodelMapper;
import org.wikidata.wdtk.datamodel.implementation.EntityDocumentImpl;
import org.wikidata.wdtk.datamodel.implementation.EntityIdValueImpl;
import org.wikidata.wdtk.datamodel.interfaces.EntityDocument;
import org.wikidata.wdtk.datamodel.interfaces.EntityIdValue;
import org.wikidata.wdtk.datamodel.interfaces.ItemDocument;
import org.wikidata.wdtk.datamodel.interfaces.MediaInfoDocument;
import org.wikidata.wdtk.datamodel.interfaces.MediaInfoIdValue;
import org.wikidata.wdtk.datamodel.interfaces.SiteLink;
import org.wikidata.wdtk.wikibaseapi.ApiConnection;
import org.wikidata.wdtk.wikibaseapi.WbGetEntitiesActionData;
import org.wikidata.wdtk.wikibaseapi.apierrors.MediaWikiApiErrorException;

public class WbGetEntitiesAction {
    static final Logger logger = LoggerFactory.getLogger(WbGetEntitiesAction.class);
    final ApiConnection connection;
    final String siteIri;
    final ObjectMapper mapper;

    public WbGetEntitiesAction(ApiConnection connection, String siteIri) {
        this.connection = connection;
        this.siteIri = siteIri;
        this.mapper = new DatamodelMapper(siteIri);
    }

    public Map<String, EntityDocument> wbGetEntities(WbGetEntitiesActionData properties) throws MediaWikiApiErrorException, IOException {
        return this.wbGetEntities(properties.ids, properties.sites, properties.titles, properties.props, properties.languages, properties.sitefilter);
    }

    public Map<String, EntityDocument> wbGetEntities(String ids, String sites, String titles, String props, String languages, String sitefilter) throws MediaWikiApiErrorException, IOException {
        List titlesList;
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("action", "wbgetentities");
        List<Object> list = titlesList = titles == null ? Collections.emptyList() : Arrays.asList(titles.split("-"));
        if (ids != null) {
            parameters.put("ids", ids);
            if (titles != null || sites != null) {
                throw new IllegalArgumentException("Cannot use parameters \"sites\" or \"titles\" when using ids to get entity data");
            }
        } else if (titles != null) {
            parameters.put("titles", titles);
            if (sites == null) {
                throw new IllegalArgumentException("Sites parameter is required when using titles parameter to get entity data.");
            }
            parameters.put("sites", sites);
        } else {
            throw new IllegalArgumentException("Either ids, or titles and site must be specified for this action.");
        }
        if (props != null) {
            parameters.put("props", props);
        }
        if (languages != null) {
            parameters.put("languages", languages);
        }
        if (sitefilter != null) {
            parameters.put("sitefilter", sitefilter);
        }
        HashMap<String, EntityDocument> result = new HashMap<String, EntityDocument>();
        try {
            JsonNode root = this.connection.sendJsonRequest("POST", parameters);
            JsonNode entities = root.path("entities");
            Iterator entitiesIterator = entities.fields();
            int i = 0;
            while (entitiesIterator.hasNext()) {
                Map.Entry entry = (Map.Entry)entitiesIterator.next();
                JsonNode entityNode = (JsonNode)entry.getValue();
                if (!entityNode.has("missing")) {
                    try {
                        EntityDocument ed = (EntityDocument)this.mapper.reader().with(DeserializationFeature.ACCEPT_EMPTY_ARRAY_AS_NULL_OBJECT).treeToValue((TreeNode)entityNode, EntityDocumentImpl.class);
                        if (titles == null) {
                            result.put((String)entry.getKey(), ed);
                        } else if (ed instanceof ItemDocument) {
                            SiteLink siteLink = (SiteLink)((ItemDocument)ed).getSiteLinks().get(sites);
                            if (siteLink != null) {
                                result.put(siteLink.getPageTitle(), ed);
                            }
                        } else if (ed instanceof MediaInfoDocument) {
                            result.put(entityNode.get("title").textValue(), ed);
                        }
                    }
                    catch (JsonProcessingException e) {
                        logger.error("Error when reading JSON for entity " + entityNode.path("id").asText("UNKNOWN") + ": " + e.toString());
                    }
                } else if (entityNode.has("id")) {
                    try {
                        EntityIdValue entityIdValue = EntityIdValueImpl.fromId((String)entityNode.get("id").asText(), (String)this.siteIri);
                        if (entityIdValue instanceof MediaInfoIdValue) {
                            result.put((String)titlesList.get(i), (EntityDocument)Datamodel.makeMediaInfoDocument((MediaInfoIdValue)((MediaInfoIdValue)entityIdValue)));
                        }
                    }
                    catch (IllegalArgumentException e) {
                        logger.warn("Invalid entity id returned: " + entityNode.get("id").asText());
                    }
                }
                ++i;
            }
        }
        catch (IOException e) {
            logger.error("Could not retrive data: " + e.toString());
            throw e;
        }
        return result;
    }
}

