/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.wikibaseapi;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wikidata.wdtk.wikibaseapi.ApiConnection;
import org.wikidata.wdtk.wikibaseapi.JacksonWbSearchEntitiesResult;
import org.wikidata.wdtk.wikibaseapi.WbGetEntitiesSearchData;
import org.wikidata.wdtk.wikibaseapi.WbSearchEntitiesResult;
import org.wikidata.wdtk.wikibaseapi.apierrors.MediaWikiApiErrorException;

public class WbSearchEntitiesAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(WbSearchEntitiesAction.class);
    private final ApiConnection connection;
    private final String siteIri;
    private final ObjectMapper mapper = new ObjectMapper();

    public WbSearchEntitiesAction(ApiConnection connection, String siteUri) {
        this.connection = connection;
        this.siteIri = siteUri;
    }

    public List<WbSearchEntitiesResult> wbSearchEntities(WbGetEntitiesSearchData properties) throws MediaWikiApiErrorException, IOException {
        return this.wbSearchEntities(properties.search, properties.language, properties.strictlanguage, properties.type, properties.limit, properties.offset);
    }

    public List<WbSearchEntitiesResult> wbSearchEntities(String search, String language, Boolean strictLanguage, String type, Long limit, Long offset) throws MediaWikiApiErrorException, IOException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("action", "wbsearchentities");
        if (search == null) {
            throw new IllegalArgumentException("Search parameter must be specified for this action.");
        }
        parameters.put("search", search);
        if (language == null) {
            throw new IllegalArgumentException("Language parameter must be specified for this action.");
        }
        parameters.put("language", language);
        if (strictLanguage != null) {
            parameters.put("strictlanguage", Boolean.toString(strictLanguage));
        }
        if (type != null) {
            parameters.put("type", type);
        }
        if (limit != null) {
            parameters.put("limit", Long.toString(limit));
        }
        if (offset != null) {
            parameters.put("continue", Long.toString(offset));
        }
        ArrayList<WbSearchEntitiesResult> results = new ArrayList<WbSearchEntitiesResult>();
        JsonNode root = this.connection.sendJsonRequest("POST", parameters);
        JsonNode entities = root.path("search");
        for (JsonNode entityNode : entities) {
            try {
                JacksonWbSearchEntitiesResult ed = (JacksonWbSearchEntitiesResult)this.mapper.treeToValue((TreeNode)entityNode, JacksonWbSearchEntitiesResult.class);
                results.add(ed);
            }
            catch (JsonProcessingException e) {
                LOGGER.error("Error when reading JSON for entity " + entityNode.path("id").asText("UNKNOWN") + ": " + e.toString());
            }
        }
        return results;
    }
}

