/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.wikibaseapi;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.wikidata.wdtk.datamodel.helpers.Datamodel;
import org.wikidata.wdtk.datamodel.helpers.DatamodelMapper;
import org.wikidata.wdtk.datamodel.implementation.EntityDocumentImpl;
import org.wikidata.wdtk.datamodel.implementation.EntityIdValueImpl;
import org.wikidata.wdtk.datamodel.interfaces.EntityDocument;
import org.wikidata.wdtk.datamodel.interfaces.ItemDocument;
import org.wikidata.wdtk.datamodel.interfaces.MediaInfoDocument;
import org.wikidata.wdtk.datamodel.interfaces.MediaInfoIdValue;
import org.wikidata.wdtk.datamodel.interfaces.SiteLink;
import org.wikidata.wdtk.wikibaseapi.ApiConnection;
import org.wikidata.wdtk.wikibaseapi.MalformedResponseException;
import org.wikidata.wdtk.wikibaseapi.WbGetEntitiesActionData;
import org.wikidata.wdtk.wikibaseapi.apierrors.MediaWikiApiErrorException;

public class WbGetEntitiesAction {
    final ApiConnection connection;
    final String siteIri;
    final ObjectMapper mapper;

    public WbGetEntitiesAction(ApiConnection connection, String siteIri) {
        this.connection = connection;
        this.siteIri = siteIri;
        this.mapper = new DatamodelMapper(siteIri);
    }

    public Map<String, EntityDocument> wbGetEntities(WbGetEntitiesActionData properties) throws MediaWikiApiErrorException, IOException {
        return this.wbGetEntities(properties.ids, properties.sites, properties.titles, properties.props, properties.languages, properties.sitefilter);
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public Map<String, EntityDocument> wbGetEntities(String ids, String sites, String titles, String props, String languages, String sitefilter) throws MediaWikiApiErrorException, IOException {
        parameters = new HashMap<String, String>();
        parameters.put("action", "wbgetentities");
        v0 /* !! */  = titlesList = titles == null ? Collections.emptyList() : Arrays.asList(titles.split("-"));
        if (ids != null) {
            parameters.put("ids", ids);
            if (titles != null || sites != null) {
                throw new IllegalArgumentException("Cannot use parameters \"sites\" or \"titles\" when using ids to get entity data");
            }
        } else if (titles != null) {
            parameters.put("titles", titles);
            if (sites == null) {
                throw new IllegalArgumentException("Sites parameter is required when using titles parameter to get entity data.");
            }
            parameters.put("sites", sites);
        } else {
            throw new IllegalArgumentException("Either ids, or titles and site must be specified for this action.");
        }
        if (props != null) {
            parameters.put("props", props);
        }
        if (languages != null) {
            parameters.put("languages", languages);
        }
        if (sitefilter != null) {
            parameters.put("sitefilter", sitefilter);
        }
        result = new HashMap<String, EntityDocument>();
        root = this.connection.sendJsonRequest("POST", parameters);
        entities = root.path("entities");
        entitiesIterator = entities.fields();
        i = 0;
        while (entitiesIterator.hasNext()) {
            entry = (Map.Entry)entitiesIterator.next();
            entityNode = (JsonNode)entry.getValue();
            if (!entityNode.has("missing")) {
                try {
                    ed = (EntityDocument)this.mapper.reader().with(DeserializationFeature.ACCEPT_EMPTY_ARRAY_AS_NULL_OBJECT).treeToValue((TreeNode)entityNode, EntityDocumentImpl.class);
                    if (titles == null) {
                        result.put((String)entry.getKey(), ed);
                    }
                    if (ed instanceof ItemDocument) {
                        siteLink = (SiteLink)((ItemDocument)ed).getSiteLinks().get(sites);
                        if (siteLink == null) ** GOTO lbl68
                        result.put(siteLink.getPageTitle(), ed);
                    }
                    if (!(ed instanceof MediaInfoDocument)) ** GOTO lbl68
                    result.put(entityNode.get("title").textValue(), ed);
                }
                catch (JsonProcessingException e) {
                    throw new MalformedResponseException("Error when reading JSON for entity " + entityNode.path("id").asText("UNKNOWN"), e);
                }
            } else if (entityNode.has("id")) {
                try {
                    entityIdValue = EntityIdValueImpl.fromId((String)entityNode.get("id").asText(), (String)this.siteIri);
                    if (entityIdValue instanceof MediaInfoIdValue) {
                        emptyDocument = Datamodel.makeMediaInfoDocument((MediaInfoIdValue)((MediaInfoIdValue)entityIdValue));
                        key = null;
                        key = titles != null ? (String)titlesList.get(i) : entityIdValue.getId();
                        result.put(key, (EntityDocument)emptyDocument);
                    }
                }
                catch (IllegalArgumentException e) {
                    throw new MalformedResponseException("Invalid entity id returned: " + entityNode.get("id").asText(), e);
                }
            }
lbl68:
            // 8 sources

            ++i;
        }
        return result;
    }
}

