/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.wikibaseapi;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.wikidata.wdtk.datamodel.helpers.EntityUpdateBuilder;
import org.wikidata.wdtk.datamodel.helpers.JsonSerializer;
import org.wikidata.wdtk.datamodel.helpers.LabeledDocumentUpdateBuilder;
import org.wikidata.wdtk.datamodel.helpers.LexemeUpdateBuilder;
import org.wikidata.wdtk.datamodel.helpers.StatementDocumentUpdateBuilder;
import org.wikidata.wdtk.datamodel.helpers.StatementUpdateBuilder;
import org.wikidata.wdtk.datamodel.helpers.TermUpdateBuilder;
import org.wikidata.wdtk.datamodel.helpers.TermedDocumentUpdateBuilder;
import org.wikidata.wdtk.datamodel.interfaces.AliasUpdate;
import org.wikidata.wdtk.datamodel.interfaces.EntityDocument;
import org.wikidata.wdtk.datamodel.interfaces.EntityIdValue;
import org.wikidata.wdtk.datamodel.interfaces.EntityUpdate;
import org.wikidata.wdtk.datamodel.interfaces.FormUpdate;
import org.wikidata.wdtk.datamodel.interfaces.ItemDocument;
import org.wikidata.wdtk.datamodel.interfaces.ItemIdValue;
import org.wikidata.wdtk.datamodel.interfaces.LabeledStatementDocumentUpdate;
import org.wikidata.wdtk.datamodel.interfaces.LexemeDocument;
import org.wikidata.wdtk.datamodel.interfaces.LexemeIdValue;
import org.wikidata.wdtk.datamodel.interfaces.LexemeUpdate;
import org.wikidata.wdtk.datamodel.interfaces.MediaInfoDocument;
import org.wikidata.wdtk.datamodel.interfaces.MonolingualTextValue;
import org.wikidata.wdtk.datamodel.interfaces.PropertyDocument;
import org.wikidata.wdtk.datamodel.interfaces.PropertyIdValue;
import org.wikidata.wdtk.datamodel.interfaces.SenseUpdate;
import org.wikidata.wdtk.datamodel.interfaces.Statement;
import org.wikidata.wdtk.datamodel.interfaces.StatementDocument;
import org.wikidata.wdtk.datamodel.interfaces.StatementDocumentUpdate;
import org.wikidata.wdtk.datamodel.interfaces.TermedStatementDocument;
import org.wikidata.wdtk.datamodel.interfaces.TermedStatementDocumentUpdate;
import org.wikidata.wdtk.wikibaseapi.ApiConnection;
import org.wikidata.wdtk.wikibaseapi.GuidGenerator;
import org.wikidata.wdtk.wikibaseapi.RandomGuidGenerator;
import org.wikidata.wdtk.wikibaseapi.StatementUpdate;
import org.wikidata.wdtk.wikibaseapi.TermStatementUpdate;
import org.wikidata.wdtk.wikibaseapi.WbEditingAction;
import org.wikidata.wdtk.wikibaseapi.WikibaseDataFetcher;
import org.wikidata.wdtk.wikibaseapi.apierrors.MediaWikiApiErrorException;

public class WikibaseDataEditor {
    final WbEditingAction wbEditingAction;
    final WikibaseDataFetcher wikibaseDataFetcher;
    final GuidGenerator guidGenerator;
    final String siteIri;
    boolean editAsBot = false;

    public WikibaseDataEditor(ApiConnection connection, String siteUri) {
        this.wbEditingAction = new WbEditingAction(connection, siteUri);
        this.wikibaseDataFetcher = new WikibaseDataFetcher(connection, siteUri);
        this.siteIri = siteUri;
        this.guidGenerator = new RandomGuidGenerator();
    }

    public WikibaseDataEditor(ApiConnection connection, String siteUri, GuidGenerator generator) {
        this.wbEditingAction = new WbEditingAction(connection, siteUri);
        this.wikibaseDataFetcher = new WikibaseDataFetcher(connection, siteUri);
        this.siteIri = siteUri;
        this.guidGenerator = generator;
    }

    WikibaseDataEditor(WbEditingAction action, WikibaseDataFetcher fetcher, String siteUri, GuidGenerator generator) {
        this.wbEditingAction = action;
        this.wikibaseDataFetcher = fetcher;
        this.siteIri = siteUri;
        this.guidGenerator = generator;
    }

    public boolean editAsBot() {
        return this.editAsBot;
    }

    public void setEditAsBot(boolean editAsBot) {
        this.editAsBot = editAsBot;
    }

    public int getMaxLag() {
        return this.wbEditingAction.getMaxLag();
    }

    public void setMaxLag(int maxLag) {
        this.wbEditingAction.setMaxLag(maxLag);
    }

    public int getMaxLagMaxRetries() {
        return this.wbEditingAction.getMaxLagMaxRetries();
    }

    public void setMaxLagMaxRetries(int retries) {
        this.wbEditingAction.setMaxLagMaxRetries(retries);
    }

    public int getMaxLagFirstWaitTime() {
        return this.wbEditingAction.getMaxLagFirstWaitTime();
    }

    public void setMaxLagFirstWaitTime(int time) {
        this.wbEditingAction.setMaxLagFirstWaitTime(time);
    }

    public double getMaxLagBackOffFactor() {
        return this.wbEditingAction.getMaxLagBackOffFactor();
    }

    public void setMaxLagBackOffFactor(double value) {
        this.wbEditingAction.setMaxLagBackOffFactor(value);
    }

    public int getAverageTimePerEdit() {
        return this.wbEditingAction.getAverageTimePerEdit();
    }

    public void setAverageTimePerEdit(int milliseconds) {
        this.wbEditingAction.setAverageTimePerEdit(milliseconds);
    }

    public int getRemainingEdits() {
        return this.wbEditingAction.getRemainingEdits();
    }

    public void setRemainingEdits(int remainingEdits) {
        this.wbEditingAction.setRemainingEdits(remainingEdits);
    }

    public void disableEditing() {
        this.wbEditingAction.setRemainingEdits(0);
    }

    private EntityDocument createDocument(String type, EntityDocument document, String summary, List<String> tags) throws IOException, MediaWikiApiErrorException {
        String data = JsonSerializer.getJsonString((EntityDocument)document);
        return this.wbEditingAction.wbEditEntity(null, null, null, type, data, false, this.editAsBot, 0L, summary, tags);
    }

    public EntityDocument createEntityDocument(EntityDocument document, String summary, List<String> tags) throws IOException, MediaWikiApiErrorException {
        if (document instanceof ItemDocument) {
            return this.createItemDocument((ItemDocument)document, summary, tags);
        }
        if (document instanceof PropertyDocument) {
            return this.createPropertyDocument((PropertyDocument)document, summary, tags);
        }
        if (document instanceof LexemeDocument) {
            return this.createLexemeDocument((LexemeDocument)document, summary, tags);
        }
        throw new UnsupportedOperationException("Creation of entities of this type is not supported");
    }

    public ItemDocument createItemDocument(ItemDocument document, String summary, List<String> tags) throws IOException, MediaWikiApiErrorException {
        return (ItemDocument)this.createDocument("item", (EntityDocument)document, summary, tags);
    }

    public PropertyDocument createPropertyDocument(PropertyDocument document, String summary, List<String> tags) throws IOException, MediaWikiApiErrorException {
        return (PropertyDocument)this.createDocument("property", (EntityDocument)document, summary, tags);
    }

    public LexemeDocument createLexemeDocument(LexemeDocument document, String summary, List<String> tags) throws IOException, MediaWikiApiErrorException {
        return (LexemeDocument)this.createDocument("lexeme", (EntityDocument)document, summary, tags);
    }

    @Deprecated
    public ItemDocument editItemDocument(ItemDocument itemDocument, boolean clear, String summary, List<String> tags) throws IOException, MediaWikiApiErrorException {
        String data = JsonSerializer.getJsonString((ItemDocument)itemDocument);
        return (ItemDocument)this.wbEditingAction.wbEditEntity(itemDocument.getEntityId().getId(), null, null, null, data, clear, this.editAsBot, itemDocument.getRevisionId(), summary, tags);
    }

    public void editEntityDocument(EntityUpdate update, boolean clear, String summary, List<String> tags) throws IOException, MediaWikiApiErrorException {
        long revisionId = update.getBaseRevisionId();
        if (!clear) {
            String language;
            StatementDocumentUpdateBuilder builder;
            StatementDocumentUpdate typed;
            if (update.isEmpty()) {
                return;
            }
            if (update instanceof StatementDocumentUpdate) {
                Statement statement;
                typed = (StatementDocumentUpdate)update;
                if (typed.getStatements().getAdded().size() == 1) {
                    builder = StatementDocumentUpdateBuilder.forBaseRevisionId((EntityIdValue)typed.getEntityId(), (long)typed.getBaseRevisionId());
                    statement = (Statement)typed.getStatements().getAdded().stream().findFirst().get();
                    builder.updateStatements(StatementUpdateBuilder.create().add(statement).build());
                    if (builder.build().equals(update)) {
                        String statementId = this.guidGenerator.freshStatementId(typed.getEntityId().getId());
                        Statement prepared = statement.withStatementId(statementId);
                        this.wbEditingAction.wbSetClaim(JsonSerializer.getJsonString((Statement)prepared), this.editAsBot, revisionId, summary, tags);
                        return;
                    }
                }
                if (typed.getStatements().getReplaced().size() == 1) {
                    builder = StatementDocumentUpdateBuilder.forBaseRevisionId((EntityIdValue)typed.getEntityId(), (long)typed.getBaseRevisionId());
                    statement = (Statement)typed.getStatements().getReplaced().values().stream().findFirst().get();
                    builder.updateStatements(StatementUpdateBuilder.create().replace(statement).build());
                    if (builder.build().equals(update)) {
                        this.wbEditingAction.wbSetClaim(JsonSerializer.getJsonString((Statement)statement), this.editAsBot, revisionId, summary, tags);
                        return;
                    }
                }
                if (!typed.getStatements().getRemoved().isEmpty() && typed.getStatements().getRemoved().size() <= 50) {
                    builder = StatementDocumentUpdateBuilder.forBaseRevisionId((EntityIdValue)typed.getEntityId(), (long)typed.getBaseRevisionId());
                    ArrayList<String> statementIds = new ArrayList<String>(typed.getStatements().getRemoved());
                    StatementUpdateBuilder statementBuilder = StatementUpdateBuilder.create();
                    for (String statementId : statementIds) {
                        statementBuilder.remove(statementId);
                    }
                    builder.updateStatements(statementBuilder.build());
                    if (builder.build().equals(update)) {
                        this.wbEditingAction.wbRemoveClaims(statementIds, this.editAsBot, revisionId, summary, tags);
                        return;
                    }
                }
            }
            if (update instanceof LabeledStatementDocumentUpdate) {
                typed = (LabeledStatementDocumentUpdate)update;
                if (typed.getLabels().getModified().size() == 1) {
                    builder = LabeledDocumentUpdateBuilder.forBaseRevisionId((EntityIdValue)typed.getEntityId(), (long)typed.getBaseRevisionId());
                    MonolingualTextValue label = (MonolingualTextValue)typed.getLabels().getModified().values().stream().findFirst().get();
                    builder.updateLabels(TermUpdateBuilder.create().put(label).build());
                    if (builder.build().equals(update)) {
                        this.wbEditingAction.wbSetLabel(update.getEntityId().getId(), null, null, null, label.getLanguageCode(), label.getText(), this.editAsBot, revisionId, summary, tags);
                        return;
                    }
                }
                if (typed.getLabels().getRemoved().size() == 1) {
                    builder = LabeledDocumentUpdateBuilder.forBaseRevisionId((EntityIdValue)typed.getEntityId(), (long)typed.getBaseRevisionId());
                    language = (String)typed.getLabels().getRemoved().stream().findFirst().get();
                    builder.updateLabels(TermUpdateBuilder.create().remove(language).build());
                    if (builder.build().equals(update)) {
                        this.wbEditingAction.wbSetLabel(update.getEntityId().getId(), null, null, null, language, null, this.editAsBot, revisionId, summary, tags);
                        return;
                    }
                }
            }
            if (update instanceof TermedStatementDocumentUpdate) {
                typed = (TermedStatementDocumentUpdate)update;
                if (typed.getDescriptions().getModified().size() == 1) {
                    builder = TermedDocumentUpdateBuilder.forBaseRevisionId((EntityIdValue)typed.getEntityId(), (long)typed.getBaseRevisionId());
                    MonolingualTextValue description = (MonolingualTextValue)typed.getDescriptions().getModified().values().stream().findFirst().get();
                    builder.updateDescriptions(TermUpdateBuilder.create().put(description).build());
                    if (builder.build().equals(update)) {
                        this.wbEditingAction.wbSetDescription(update.getEntityId().getId(), null, null, null, description.getLanguageCode(), description.getText(), this.editAsBot, revisionId, summary, tags);
                        return;
                    }
                }
                if (typed.getDescriptions().getRemoved().size() == 1) {
                    builder = TermedDocumentUpdateBuilder.forBaseRevisionId((EntityIdValue)typed.getEntityId(), (long)typed.getBaseRevisionId());
                    language = (String)typed.getDescriptions().getRemoved().stream().findFirst().get();
                    builder.updateDescriptions(TermUpdateBuilder.create().remove(language).build());
                    if (builder.build().equals(update)) {
                        this.wbEditingAction.wbSetDescription(update.getEntityId().getId(), null, null, null, language, null, this.editAsBot, revisionId, summary, tags);
                        return;
                    }
                }
                if (typed.getAliases().size() == 1) {
                    builder = TermedDocumentUpdateBuilder.forBaseRevisionId((EntityIdValue)typed.getEntityId(), (long)typed.getBaseRevisionId());
                    language = (String)typed.getAliases().keySet().stream().findFirst().get();
                    AliasUpdate aliases = (AliasUpdate)typed.getAliases().get(language);
                    builder.updateAliases(language, aliases);
                    if (builder.build().equals(update)) {
                        List<String> added = !aliases.getAdded().isEmpty() ? aliases.getAdded().stream().map(a -> a.getText()).collect(Collectors.toList()) : null;
                        List<String> removed = !aliases.getRemoved().isEmpty() ? aliases.getRemoved().stream().map(a -> a.getText()).collect(Collectors.toList()) : null;
                        List recreated = aliases.getRecreated().map(l -> l.stream().map(a -> a.getText()).collect(Collectors.toList())).orElse(null);
                        this.wbEditingAction.wbSetAliases(update.getEntityId().getId(), null, null, null, language, added, removed, recreated, this.editAsBot, revisionId, summary, tags);
                        return;
                    }
                }
            }
            if (update instanceof LexemeUpdate) {
                typed = (LexemeUpdate)update;
                if (typed.getUpdatedSenses().size() == 1) {
                    builder = LexemeUpdateBuilder.forBaseRevisionId((LexemeIdValue)typed.getEntityId(), (long)typed.getBaseRevisionId());
                    SenseUpdate sense = (SenseUpdate)typed.getUpdatedSenses().values().stream().findFirst().get();
                    builder.updateSense(sense);
                    if (builder.build().equals(update)) {
                        this.editEntityDocument((EntityUpdate)sense, false, summary, tags);
                        return;
                    }
                }
                if (typed.getUpdatedForms().size() == 1) {
                    builder = LexemeUpdateBuilder.forBaseRevisionId((LexemeIdValue)typed.getEntityId(), (long)typed.getBaseRevisionId());
                    FormUpdate form = (FormUpdate)typed.getUpdatedForms().values().stream().findFirst().get();
                    builder.updateForm(form);
                    if (builder.build().equals(update)) {
                        this.editEntityDocument((EntityUpdate)form, false, summary, tags);
                        return;
                    }
                }
            }
        }
        String data = JsonSerializer.getJsonString((EntityUpdate)update);
        this.wbEditingAction.wbEditEntity(update.getEntityId().getId(), null, null, null, data, clear, this.editAsBot, revisionId, summary, tags);
    }

    @Deprecated
    public PropertyDocument editPropertyDocument(PropertyDocument propertyDocument, boolean clear, String summary, List<String> tags) throws IOException, MediaWikiApiErrorException {
        String data = JsonSerializer.getJsonString((PropertyDocument)propertyDocument);
        return (PropertyDocument)this.wbEditingAction.wbEditEntity(propertyDocument.getEntityId().getId(), null, null, null, data, clear, this.editAsBot, propertyDocument.getRevisionId(), summary, tags);
    }

    @Deprecated
    public MediaInfoDocument editMediaInfoDocument(MediaInfoDocument mediaInfoDocument, boolean clear, String summary, List<String> tags) throws IOException, MediaWikiApiErrorException {
        String data = JsonSerializer.getJsonString((MediaInfoDocument)mediaInfoDocument);
        return (MediaInfoDocument)this.wbEditingAction.wbEditEntity(mediaInfoDocument.getEntityId().getId(), null, null, null, data, clear, this.editAsBot, mediaInfoDocument.getRevisionId(), summary, tags);
    }

    @Deprecated
    public ItemDocument updateStatements(ItemIdValue itemIdValue, List<Statement> addStatements, List<Statement> deleteStatements, String summary, List<String> tags) throws MediaWikiApiErrorException, IOException {
        ItemDocument currentDocument = (ItemDocument)this.wikibaseDataFetcher.getEntityDocument(itemIdValue.getId());
        return this.updateStatements(currentDocument, addStatements, deleteStatements, summary, tags);
    }

    @Deprecated
    public ItemDocument updateTermsStatements(ItemIdValue itemIdValue, List<MonolingualTextValue> addLabels, List<MonolingualTextValue> addDescriptions, List<MonolingualTextValue> addAliases, List<MonolingualTextValue> deleteAliases, List<Statement> addStatements, List<Statement> deleteStatements, String summary, List<String> tags) throws MediaWikiApiErrorException, IOException {
        ItemDocument currentDocument = (ItemDocument)this.wikibaseDataFetcher.getEntityDocument(itemIdValue.getId());
        return this.updateTermsStatements(currentDocument, addLabels, addDescriptions, addAliases, deleteAliases, addStatements, deleteStatements, summary, tags);
    }

    @Deprecated
    public PropertyDocument updateStatements(PropertyIdValue propertyIdValue, List<Statement> addStatements, List<Statement> deleteStatements, String summary, List<String> tags) throws MediaWikiApiErrorException, IOException {
        PropertyDocument currentDocument = (PropertyDocument)this.wikibaseDataFetcher.getEntityDocument(propertyIdValue.getId());
        return this.updateStatements(currentDocument, addStatements, deleteStatements, summary, tags);
    }

    @Deprecated
    public <T extends StatementDocument> T updateStatements(T currentDocument, List<Statement> addStatements, List<Statement> deleteStatements, String summary, List<String> tags) throws MediaWikiApiErrorException, IOException {
        StatementUpdate statementUpdate = new StatementUpdate(currentDocument, addStatements, deleteStatements);
        statementUpdate.setGuidGenerator(this.guidGenerator);
        if (statementUpdate.isEmptyEdit()) {
            return currentDocument;
        }
        return (T)((StatementDocument)this.wbEditingAction.wbEditEntity(currentDocument.getEntityId().getId(), null, null, null, statementUpdate.getJsonUpdateString(), false, this.editAsBot, currentDocument.getRevisionId(), summary, tags));
    }

    @Deprecated
    public <T extends TermedStatementDocument> T updateTermsStatements(T currentDocument, List<MonolingualTextValue> addLabels, List<MonolingualTextValue> addDescriptions, List<MonolingualTextValue> addAliases, List<MonolingualTextValue> deleteAliases, List<Statement> addStatements, List<Statement> deleteStatements, String summary, List<String> tags) throws MediaWikiApiErrorException, IOException {
        TermStatementUpdate termStatementUpdate = new TermStatementUpdate(currentDocument, addStatements, deleteStatements, addLabels, addDescriptions, addAliases, deleteAliases);
        termStatementUpdate.setGuidGenerator(this.guidGenerator);
        return (T)termStatementUpdate.performEdit(this.wbEditingAction, this.editAsBot, summary, tags);
    }

    public void nullEdit(EntityIdValue entityId) throws IOException, MediaWikiApiErrorException {
        this.nullEdit(this.wikibaseDataFetcher.getEntityDocument(entityId.getId()));
    }

    @Deprecated
    public <T extends StatementDocument> void nullEdit(ItemIdValue itemId) throws IOException, MediaWikiApiErrorException {
        ItemDocument currentDocument = (ItemDocument)this.wikibaseDataFetcher.getEntityDocument(itemId.getId());
        this.nullEdit(currentDocument);
    }

    @Deprecated
    public <T extends StatementDocument> void nullEdit(PropertyIdValue propertyId) throws IOException, MediaWikiApiErrorException {
        PropertyDocument currentDocument = (PropertyDocument)this.wikibaseDataFetcher.getEntityDocument(propertyId.getId());
        this.nullEdit(currentDocument);
    }

    public <T extends EntityDocument> T nullEdit(T currentDocument) throws IOException, MediaWikiApiErrorException {
        EntityUpdate update = EntityUpdateBuilder.forBaseRevision(currentDocument).build();
        return (T)this.wbEditingAction.wbEditEntity(currentDocument.getEntityId().getId(), null, null, null, JsonSerializer.getJsonString((EntityUpdate)update), false, this.editAsBot, currentDocument.getRevisionId(), null, null);
    }
}

