/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.wikibaseapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.net.CookieStore;
import java.net.HttpCookie;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.CookieJar;
import okhttp3.JavaNetCookieJar;
import okhttp3.OkHttpClient;
import org.wikidata.wdtk.wikibaseapi.ApiConnection;
import org.wikidata.wdtk.wikibaseapi.LoginFailedException;
import org.wikidata.wdtk.wikibaseapi.LoginValue;
import org.wikidata.wdtk.wikibaseapi.NeedLoginTokenException;
import org.wikidata.wdtk.wikibaseapi.apierrors.MediaWikiApiErrorException;

public class BasicApiConnection
extends ApiConnection {
    @JsonIgnore
    String password = "";
    private final CookieManager cookieManager;

    public BasicApiConnection(String apiBaseUrl) {
        super(apiBaseUrl);
        this.cookieManager = new CookieManager();
        this.cookieManager.setCookiePolicy(CookiePolicy.ACCEPT_ALL);
    }

    @JsonCreator
    protected BasicApiConnection(@JsonProperty(value="baseUrl") String apiBaseUrl, @JsonProperty(value="cookies") List<HttpCookieWrapper> cookies, @JsonProperty(value="username") String username, @JsonProperty(value="loggedIn") boolean loggedIn, @JsonProperty(value="tokens") Map<String, String> tokens, @JsonProperty(value="connectTimeout") int connectTimeout, @JsonProperty(value="readTimeout") int readTimeout) {
        super(apiBaseUrl, tokens);
        this.username = username;
        this.loggedIn = loggedIn;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.cookieManager = new CookieManager();
        this.cookieManager.setCookiePolicy(CookiePolicy.ACCEPT_ALL);
        CookieStore cookieStore = this.cookieManager.getCookieStore();
        URI uri = URI.create(apiBaseUrl);
        cookies.stream().map(HttpCookieWrapper::toHttpCookie).forEach(cookie -> cookieStore.add(uri, (HttpCookie)cookie));
    }

    @Override
    protected OkHttpClient.Builder getClientBuilder() {
        return new OkHttpClient.Builder().cookieJar((CookieJar)new JavaNetCookieJar((CookieHandler)this.cookieManager));
    }

    public static BasicApiConnection getTestWikidataApiConnection() {
        return new BasicApiConnection("https://test.wikidata.org/w/api.php");
    }

    public static BasicApiConnection getWikidataApiConnection() {
        return new BasicApiConnection("https://www.wikidata.org/w/api.php");
    }

    public static BasicApiConnection getWikimediaCommonsApiConnection() {
        return new BasicApiConnection("https://commons.wikimedia.org/w/api.php");
    }

    public void login(String username, String password) throws LoginFailedException {
        this.login(username, password, this::confirmLogin);
    }

    public void clientLogin(String username, String password) throws LoginFailedException {
        this.login(username, password, this::confirmClientLogin);
    }

    protected void login(String username, String password, ILogin loginFunction) throws LoginFailedException {
        try {
            String token = this.getOrFetchToken("login");
            try {
                loginFunction.login(token, username, password);
            }
            catch (NeedLoginTokenException e) {
                this.clearToken("login");
                token = this.getOrFetchToken("login");
                loginFunction.login(token, username, password);
            }
        }
        catch (IOException | MediaWikiApiErrorException e1) {
            throw new LoginFailedException(e1.getMessage(), e1);
        }
    }

    protected void confirmLogin(String token, String username, String password) throws IOException, LoginFailedException, MediaWikiApiErrorException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("action", "login");
        params.put(LoginValue.PARAM_LOGIN_USERNAME.getLoginText(), username);
        params.put(LoginValue.PARAM_LOGIN_PASSWORD.getLoginText(), password);
        params.put(LoginValue.PARAM_LOGIN_TOKEN.getLoginText(), token);
        JsonNode root = this.sendJsonRequest("POST", params);
        String result = root.path("login").path("result").textValue();
        if (!LoginValue.LOGIN_RESULT_SUCCESS.getLoginText().equals(result)) {
            String message = null;
            if (LoginValue.FAILED.getLoginText().equals(result)) {
                message = root.path("login").path("reason").textValue();
            }
            if (message == null) {
                message = LoginValue.of(result).getMessage(result);
            }
            logger.warn(message);
            if (LoginValue.LOGIN_WRONG_TOKEN.getLoginText().equals(result)) {
                throw new NeedLoginTokenException(message);
            }
            throw new LoginFailedException(message);
        }
        this.loggedIn = true;
        this.username = username;
        this.password = password;
    }

    protected void confirmClientLogin(String token, String username, String password) throws IOException, LoginFailedException, MediaWikiApiErrorException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("action", "clientlogin");
        params.put(LoginValue.PARAM_LOGIN_USERNAME.getClientLoginText(), username);
        params.put(LoginValue.PARAM_LOGIN_PASSWORD.getClientLoginText(), password);
        params.put(LoginValue.PARAM_LOGIN_TOKEN.getClientLoginText(), token);
        params.put("loginreturnurl", this.apiBaseUrl);
        JsonNode root = this.sendJsonRequest("POST", params);
        String result = root.path("clientlogin").path("status").textValue();
        if (!"PASS".equals(result)) {
            String messagecode = "FAIL".equals(result) ? root.path("clientlogin").path("messagecode").textValue() : root.path("error").path("code").textValue();
            String message = LoginValue.of(messagecode).getMessage(messagecode);
            logger.warn(message);
            if (LoginValue.LOGIN_WRONG_TOKEN.getClientLoginText().equals(messagecode)) {
                throw new NeedLoginTokenException(message);
            }
            throw new LoginFailedException(message);
        }
        this.loggedIn = true;
        this.username = username;
        this.password = password;
    }

    @JsonProperty(value="cookies")
    public List<HttpCookie> getCookies() {
        return this.cookieManager.getCookieStore().getCookies();
    }

    public void clearCookies() throws IOException, MediaWikiApiErrorException {
        this.logout();
        this.cookieManager.getCookieStore().removeAll();
    }

    @Override
    public void logout() throws IOException, MediaWikiApiErrorException {
        if (this.loggedIn) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("action", "logout");
            params.put("token", this.getOrFetchToken("csrf"));
            params.put("format", "json");
            this.sendJsonRequest("POST", params);
            this.loggedIn = false;
            this.username = "";
            this.password = "";
        }
    }

    private static interface ILogin {
        public void login(String var1, String var2, String var3) throws IOException, LoginFailedException, MediaWikiApiErrorException;
    }

    protected static class HttpCookieWrapper {
        private HttpCookie httpCookie;

        @JsonCreator
        public HttpCookieWrapper(@JsonProperty(value="name") String name, @JsonProperty(value="value") String value, @JsonProperty(value="comment") String comment, @JsonProperty(value="commentURL") String commentURL, @JsonProperty(value="domain") String domain, @JsonProperty(value="maxAge") int maxAge, @JsonProperty(value="path") String path, @JsonProperty(value="portlist") String portlist, @JsonProperty(value="secure") boolean secure, @JsonProperty(value="httpOnly") boolean httpOnly, @JsonProperty(value="version") int version, @JsonProperty(value="discard") boolean discard) {
            this.httpCookie = new HttpCookie(name, value);
            this.httpCookie.setComment(comment);
            this.httpCookie.setCommentURL(commentURL);
            this.httpCookie.setDomain(domain);
            this.httpCookie.setMaxAge(maxAge);
            this.httpCookie.setPath(path);
            this.httpCookie.setPortlist(portlist);
            this.httpCookie.setSecure(secure);
            this.httpCookie.setHttpOnly(httpOnly);
            this.httpCookie.setVersion(version);
            this.httpCookie.setDiscard(discard);
        }

        public HttpCookie toHttpCookie() {
            return this.httpCookie;
        }
    }
}

