/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.wikibaseapi;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.wikidata.wdtk.wikibaseapi.apierrors.MaxlagErrorException;
import org.wikidata.wdtk.wikibaseapi.apierrors.MediaWikiApiErrorException;
import org.wikidata.wdtk.wikibaseapi.apierrors.MediaWikiApiErrorHandler;

@JsonIgnoreProperties(ignoreUnknown=true)
public abstract class ApiConnection {
    static final Logger logger = LoggerFactory.getLogger(ApiConnection.class);
    public static final String URL_WIKIDATA_API = "https://www.wikidata.org/w/api.php";
    public static final String URL_TEST_WIKIDATA_API = "https://test.wikidata.org/w/api.php";
    public static final String URL_WIKIMEDIA_COMMONS_API = "https://commons.wikimedia.org/w/api.php";
    protected static final String PARAM_ACTION = "action";
    protected static final String PARAM_FORMAT = "format";
    protected static final String ASSERT_PARAMETER = "assert";
    protected static final MediaType URLENCODED_MEDIA_TYPE = MediaType.parse((String)"application/x-www-form-urlencoded");
    protected final String apiBaseUrl;
    protected boolean loggedIn = false;
    protected String username = "";
    protected final Map<String, String> tokens;
    protected int connectTimeout = -1;
    protected int readTimeout = -1;
    private OkHttpClient client;
    private final ObjectMapper mapper = new ObjectMapper();

    public ApiConnection(String apiBaseUrl) {
        this(apiBaseUrl, null);
    }

    public ApiConnection(String apiBaseUrl, Map<String, String> tokens) {
        this.apiBaseUrl = apiBaseUrl;
        this.tokens = tokens != null ? tokens : new HashMap();
    }

    protected abstract OkHttpClient.Builder getClientBuilder();

    @JsonProperty(value="baseUrl")
    public String getApiBaseUrl() {
        return this.apiBaseUrl;
    }

    @JsonProperty(value="loggedIn")
    public boolean isLoggedIn() {
        return this.loggedIn;
    }

    public void checkCredentials() throws IOException, MediaWikiApiErrorException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(PARAM_ACTION, "query");
        this.sendJsonRequest("POST", parameters);
    }

    @JsonProperty(value="username")
    public String getCurrentUser() {
        return this.username;
    }

    @JsonProperty(value="tokens")
    public Map<String, String> getTokens() {
        return Collections.unmodifiableMap(this.tokens);
    }

    public void setConnectTimeout(int timeout) {
        this.connectTimeout = timeout;
        this.client = null;
    }

    public void setReadTimeout(int timeout) {
        this.readTimeout = timeout;
        this.client = null;
    }

    @JsonProperty(value="connectTimeout")
    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    @JsonProperty(value="readTimeout")
    public int getReadTimeout() {
        return this.readTimeout;
    }

    public abstract void logout() throws IOException, MediaWikiApiErrorException;

    String getOrFetchToken(String tokenType) throws IOException, MediaWikiApiErrorException {
        if (this.tokens.containsKey(tokenType)) {
            return this.tokens.get(tokenType);
        }
        String value = this.fetchToken(tokenType);
        this.tokens.put(tokenType, value);
        return value;
    }

    void clearToken(String tokenType) {
        this.tokens.remove(tokenType);
    }

    private String fetchToken(String tokenType) throws IOException, MediaWikiApiErrorException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put(PARAM_ACTION, "query");
        params.put("meta", "tokens");
        params.put("type", tokenType);
        JsonNode root = this.sendJsonRequest("POST", params);
        return root.path("query").path("tokens").path(tokenType + "token").textValue();
    }

    public JsonNode sendJsonRequest(String requestMethod, Map<String, String> parameters) throws IOException, MediaWikiApiErrorException {
        return this.sendJsonRequest(requestMethod, parameters, null);
    }

    public JsonNode sendJsonRequest(String requestMethod, Map<String, String> parameters, Map<String, ImmutablePair<String, File>> files) throws IOException, MediaWikiApiErrorException {
        parameters.put(PARAM_FORMAT, "json");
        if (this.loggedIn) {
            parameters.put(ASSERT_PARAMETER, "user");
        }
        try (InputStream response = this.sendRequest(requestMethod, parameters, files);){
            JsonNode root = this.mapper.readTree(response);
            this.checkErrors(root);
            this.logWarnings(root);
            JsonNode jsonNode = root;
            return jsonNode;
        }
    }

    public InputStream sendRequest(String requestMethod, Map<String, String> parameters, Map<String, ImmutablePair<String, File>> files) throws IOException {
        Request request;
        String queryString = this.getQueryString(parameters);
        if ("GET".equalsIgnoreCase(requestMethod)) {
            request = new Request.Builder().url(this.apiBaseUrl + "?" + queryString).build();
        } else if ("POST".equalsIgnoreCase(requestMethod)) {
            RequestBody body;
            if (files != null && !files.isEmpty()) {
                MediaType formDataMediaType = MediaType.parse((String)"multipart/form-data");
                MultipartBody.Builder builder = new MultipartBody.Builder();
                builder.setType(formDataMediaType);
                parameters.entrySet().stream().forEach(entry -> builder.addFormDataPart((String)entry.getKey(), (String)entry.getValue()));
                files.entrySet().stream().forEach(entry -> builder.addFormDataPart((String)entry.getKey(), (String)((ImmutablePair)entry.getValue()).getLeft(), RequestBody.create((MediaType)formDataMediaType, (File)((File)((ImmutablePair)entry.getValue()).getRight()))));
                body = builder.build();
            } else {
                body = RequestBody.create((String)queryString, (MediaType)URLENCODED_MEDIA_TYPE);
            }
            request = new Request.Builder().url(this.apiBaseUrl).post(body).build();
        } else {
            throw new IllegalArgumentException("Expected the requestMethod to be either GET or POST, but got " + requestMethod);
        }
        if (this.client == null) {
            this.buildClient();
        }
        Response response = this.client.newCall(request).execute();
        return Objects.requireNonNull(response.body()).byteStream();
    }

    private void buildClient() {
        OkHttpClient.Builder builder = this.getClientBuilder();
        if (this.connectTimeout >= 0) {
            builder.connectTimeout((long)this.connectTimeout, TimeUnit.MILLISECONDS);
        }
        if (this.readTimeout >= 0) {
            builder.readTimeout((long)this.readTimeout, TimeUnit.MILLISECONDS);
        }
        this.client = builder.build();
    }

    protected void checkErrors(JsonNode root) throws MediaWikiApiErrorException {
        if (root.has("error")) {
            JsonNode errorNode = root.path("error");
            String code = errorNode.path("code").asText("UNKNOWN");
            String info = errorNode.path("info").asText("No details provided");
            if (errorNode.has("lag") && "maxlag".equals(code)) {
                double lag = errorNode.path("lag").asDouble();
                throw new MaxlagErrorException(info, lag);
            }
            MediaWikiApiErrorHandler.throwMediaWikiApiErrorException(code, info);
        }
    }

    protected void logWarnings(JsonNode root) {
        for (String warning : this.getWarnings(root)) {
            logger.warn("API warning " + warning);
        }
    }

    List<String> getWarnings(JsonNode root) {
        ArrayList<String> warnings = new ArrayList<String>();
        if (root.has("warnings")) {
            JsonNode warningNode = root.path("warnings");
            Iterator moduleIterator = warningNode.fields();
            while (moduleIterator.hasNext()) {
                Map.Entry moduleNode = (Map.Entry)moduleIterator.next();
                Iterator moduleOutputIterator = ((JsonNode)moduleNode.getValue()).elements();
                while (moduleOutputIterator.hasNext()) {
                    JsonNode moduleOutputNode = (JsonNode)moduleOutputIterator.next();
                    if (moduleOutputNode.isTextual()) {
                        warnings.add("[" + (String)moduleNode.getKey() + "]: " + moduleOutputNode.textValue());
                        continue;
                    }
                    if (moduleOutputNode.isArray()) {
                        Iterator messageIterator = moduleOutputNode.elements();
                        while (messageIterator.hasNext()) {
                            JsonNode messageNode = (JsonNode)messageIterator.next();
                            warnings.add("[" + (String)moduleNode.getKey() + "]: " + messageNode.path("html").path("*").asText(messageNode.toString()));
                        }
                        continue;
                    }
                    warnings.add("[" + (String)moduleNode.getKey() + "]: Warning was not understood. Please report this to Wikidata Toolkit. JSON source: " + moduleOutputNode.toString());
                }
            }
        }
        return warnings;
    }

    String getQueryString(Map<String, String> params) {
        StringBuilder builder = new StringBuilder();
        try {
            boolean first = true;
            for (Map.Entry<String, String> entry : params.entrySet()) {
                if (first) {
                    first = false;
                } else {
                    builder.append("&");
                }
                builder.append(URLEncoder.encode(entry.getKey(), "UTF-8"));
                builder.append("=");
                builder.append(URLEncoder.encode(entry.getValue(), "UTF-8"));
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Your Java version does not support UTF-8 encoding.");
        }
        return builder.toString();
    }

    public static String implodeObjects(Iterable<?> objects) {
        StringBuilder builder = new StringBuilder();
        boolean first = true;
        for (Object o : objects) {
            if (first) {
                first = false;
            } else {
                builder.append("|");
            }
            builder.append(o.toString());
        }
        return builder.toString();
    }
}

