/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.wikibaseapi.apierrors;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;

@JsonIgnoreProperties(ignoreUnknown=true)
public class MediaWikiErrorMessage {
    final String name;
    final String htmlText;

    public MediaWikiErrorMessage(String name, String htmlText) {
        this.name = name;
        this.htmlText = htmlText;
    }

    @JsonCreator
    MediaWikiErrorMessage(@JsonProperty(value="name") String name, @JsonProperty(value="html") MessageWrapper wrapper) {
        this.name = name;
        this.htmlText = wrapper.message;
    }

    public String getName() {
        return this.name;
    }

    public String getHTMLText() {
        return this.htmlText;
    }

    public int hashCode() {
        return Objects.hash(this.htmlText, this.name);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MediaWikiErrorMessage other = (MediaWikiErrorMessage)obj;
        return Objects.equals(this.htmlText, other.htmlText) && Objects.equals(this.name, other.name);
    }

    public String toString() {
        return "MediaWikiErrorMessage [name=" + this.name + ", htmlText=" + this.htmlText + "]";
    }

    protected static class MessageWrapper {
        final String message;

        @JsonCreator
        public MessageWrapper(@JsonProperty(value="*") String message) {
            this.message = message;
        }
    }
}

