/*
 * Decompiled with CFR 0.152.
 */
package org.wikidata.wdtk.wikibaseapi.apierrors;

import java.util.List;
import org.wikidata.wdtk.wikibaseapi.apierrors.AssertUserFailedException;
import org.wikidata.wdtk.wikibaseapi.apierrors.EditConflictErrorException;
import org.wikidata.wdtk.wikibaseapi.apierrors.MaxlagErrorException;
import org.wikidata.wdtk.wikibaseapi.apierrors.MediaWikiApiErrorException;
import org.wikidata.wdtk.wikibaseapi.apierrors.MediaWikiErrorMessage;
import org.wikidata.wdtk.wikibaseapi.apierrors.NoSuchEntityErrorException;
import org.wikidata.wdtk.wikibaseapi.apierrors.TagsApplyNotAllowedException;
import org.wikidata.wdtk.wikibaseapi.apierrors.TokenErrorException;

public class MediaWikiApiErrorHandler {
    public static final String ERROR_EDIT_CONFLICT = "editconflict";
    public static final String ERROR_NO_TOKEN = "notoken";
    public static final String ERROR_INVALID_TOKEN = "badtoken";
    public static final String ERROR_NO_SUCH_ENTITY = "no-such-entity";
    public static final String ERROR_MAXLAG = "maxlag";
    public static final String ERROR_ASSERT_USER_FAILED = "assertuserfailed";
    public static final String ERROR_TAGS_APPLY_NOT_ALLOWED = "tags-apply-not-allowed-one";

    public static void throwMediaWikiApiErrorException(String errorCode, String errorMessage, List<MediaWikiErrorMessage> detailedMessages) throws MediaWikiApiErrorException {
        switch (errorCode) {
            case "notoken": 
            case "badtoken": {
                throw new TokenErrorException(errorCode, errorMessage, detailedMessages);
            }
            case "editconflict": {
                throw new EditConflictErrorException(errorMessage, detailedMessages);
            }
            case "no-such-entity": {
                throw new NoSuchEntityErrorException(errorMessage, detailedMessages);
            }
            case "maxlag": {
                throw new MaxlagErrorException(errorMessage);
            }
            case "assertuserfailed": {
                throw new AssertUserFailedException(errorMessage, detailedMessages);
            }
            case "tags-apply-not-allowed-one": {
                throw new TagsApplyNotAllowedException(errorMessage, detailedMessages);
            }
        }
        throw new MediaWikiApiErrorException(errorCode, errorMessage, detailedMessages);
    }

    @Deprecated(since="0.16.0")
    public static void throwMediaWikiApiErrorException(String errorCode, String errorMessage) throws MediaWikiApiErrorException {
        switch (errorCode) {
            case "notoken": 
            case "badtoken": {
                throw new TokenErrorException(errorCode, errorMessage);
            }
            case "editconflict": {
                throw new EditConflictErrorException(errorMessage);
            }
            case "no-such-entity": {
                throw new NoSuchEntityErrorException(errorMessage);
            }
            case "maxlag": {
                throw new MaxlagErrorException(errorMessage);
            }
            case "assertuserfailed": {
                throw new AssertUserFailedException(errorMessage);
            }
            case "tags-apply-not-allowed-one": {
                throw new TagsApplyNotAllowedException(errorMessage);
            }
        }
        throw new MediaWikiApiErrorException(errorCode, errorMessage);
    }
}

