/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.container.domain;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import org.jboss.arquillian.container.spi.client.container.DeploymentException;
import org.jboss.as.arquillian.container.domain.ManagementClient;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.helpers.domain.DeployDeploymentPlanBuilder;
import org.jboss.as.controller.client.helpers.domain.DeploymentAction;
import org.jboss.as.controller.client.helpers.domain.DeploymentPlan;
import org.jboss.as.controller.client.helpers.domain.DeploymentPlanResult;
import org.jboss.as.controller.client.helpers.domain.DomainDeploymentManager;
import org.jboss.as.controller.client.helpers.domain.InitialDeploymentPlanBuilder;
import org.jboss.as.controller.client.helpers.domain.InitialDeploymentSetBuilder;
import org.jboss.as.controller.client.helpers.domain.ServerDeploymentPlanResult;
import org.jboss.as.controller.client.helpers.domain.ServerGroupDeploymentPlanBuilder;
import org.jboss.as.controller.client.helpers.domain.ServerGroupDeploymentPlanResult;
import org.jboss.as.controller.client.helpers.domain.ServerUpdateResult;
import org.jboss.as.controller.client.helpers.domain.UndeployDeploymentPlanBuilder;
import org.jboss.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.wildfly.common.Assert;
import org.wildfly.plugin.core.Deployment;
import org.wildfly.plugin.core.DeploymentManager;
import org.wildfly.plugin.core.DeploymentResult;
import org.wildfly.plugin.core.UndeployDescription;

public class ArchiveDeployer {
    private static final Logger log = Logger.getLogger(ArchiveDeployer.class);
    @Deprecated
    private final DomainDeploymentManager deploymentManagerDeprecated;
    private final DeploymentManager deploymentManager;

    @Deprecated
    public ArchiveDeployer(DomainDeploymentManager deploymentManager) {
        Assert.checkNotNullParam((String)"deploymentManager", (Object)deploymentManager);
        this.deploymentManagerDeprecated = deploymentManager;
        this.deploymentManager = null;
    }

    public ArchiveDeployer(ManagementClient client) {
        Assert.checkNotNullParam((String)"client", (Object)client);
        this.deploymentManagerDeprecated = null;
        this.deploymentManager = DeploymentManager.Factory.create((ModelControllerClient)client.getControllerClient());
    }

    public String deploy(Archive<?> archive, String serverGroup) throws DeploymentException {
        return this.deploy(archive, Collections.singleton(serverGroup));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String deploy(Archive<?> archive, Set<String> serverGroups) throws DeploymentException {
        String string;
        block15: {
            if (serverGroups.isEmpty()) {
                throw new DeploymentException("No target server groups to deploy to.");
            }
            InputStream input = ((ZipExporter)archive.as(ZipExporter.class)).exportAsInputStream();
            if (this.deploymentManager != null) {
                String name = archive.getName();
                DeploymentResult result = this.deploymentManager.deploy(Deployment.of((InputStream)input, (String)name).setServerGroups(serverGroups));
                if (!result.successful()) {
                    throw new DeploymentException("Could not deploy to container: " + result.getFailureMessage());
                }
                return name;
            }
            try {
                InitialDeploymentSetBuilder builder = this.deploymentManagerDeprecated.newDeploymentPlan().withRollbackAcrossGroups();
                DeployDeploymentPlanBuilder deployBuilder = builder.add(archive.getName(), input).andDeploy();
                ServerGroupDeploymentPlanBuilder serverGroupBuilder = null;
                for (String target : serverGroups) {
                    serverGroupBuilder = serverGroupBuilder == null ? deployBuilder.toServerGroup(target) : serverGroupBuilder.toServerGroup(target);
                }
                DeploymentPlan plan = serverGroupBuilder.build();
                DeploymentAction deployAction = (DeploymentAction)plan.getDeploymentActions().get(plan.getDeploymentActions().size() - 1);
                string = this.executeDeploymentPlan(plan, deployAction);
                if (input == null) break block15;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (IOException e) {
                            log.warnf((Throwable)e, "Failed to close resource %s", (Object)input);
                        }
                    }
                    throw throwable;
                }
                catch (DeploymentException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new DeploymentException("Could not deploy to container", (Throwable)e);
                }
            }
            try {
                input.close();
            }
            catch (IOException e) {
                log.warnf((Throwable)e, "Failed to close resource %s", (Object)input);
            }
        }
        return string;
    }

    public void undeploy(String runtimeName, String serverGroup) throws DeploymentException {
        this.undeploy(runtimeName, Collections.singleton(serverGroup));
    }

    public void undeploy(String runtimeName, Set<String> serverGroups) throws DeploymentException {
        if (serverGroups.isEmpty()) {
            throw new DeploymentException("No target server groups to deploy to.");
        }
        try {
            if (this.deploymentManager != null) {
                DeploymentResult result = this.deploymentManager.undeploy(UndeployDescription.of((String)runtimeName).addServerGroups(serverGroups));
                if (!result.successful()) {
                    log.warnf("Cannot undeploy %s: %s", (Object)runtimeName, (Object)result.getFailureMessage());
                }
            } else {
                InitialDeploymentPlanBuilder builder = this.deploymentManagerDeprecated.newDeploymentPlan();
                UndeployDeploymentPlanBuilder undeployBuilder = builder.undeploy(runtimeName);
                ServerGroupDeploymentPlanBuilder serverGroupBuilder = null;
                for (String target : serverGroups) {
                    serverGroupBuilder = serverGroupBuilder == null ? undeployBuilder.toServerGroup(target) : serverGroupBuilder.toServerGroup(target);
                }
                DeploymentPlan plan = serverGroupBuilder.build();
                Future future = this.deploymentManagerDeprecated.execute(plan);
                future.get();
            }
        }
        catch (Exception ex) {
            log.warnf("Cannot undeploy %s: %s", (Object)runtimeName, (Object)ex.getLocalizedMessage());
        }
    }

    public boolean hasDeployment(String name) throws IOException {
        return this.deploymentManager.hasDeployment(name);
    }

    public boolean hasDeployment(String name, String serverGroup) throws IOException {
        return this.deploymentManager.hasDeployment(name, serverGroup);
    }

    private String executeDeploymentPlan(DeploymentPlan plan, DeploymentAction deployAction) throws Exception {
        Future future = this.deploymentManagerDeprecated.execute(plan);
        DeploymentPlanResult planResult = (DeploymentPlanResult)future.get();
        Map actionResults = planResult.getServerGroupResults();
        for (Map.Entry result : actionResults.entrySet()) {
            for (Map.Entry planServerResult : ((ServerGroupDeploymentPlanResult)result.getValue()).getServerResults().entrySet()) {
                Exception deploymentException;
                ServerUpdateResult actionResult = (ServerUpdateResult)((ServerDeploymentPlanResult)planServerResult.getValue()).getDeploymentActionResults().get(deployAction.getId());
                if (actionResult == null || (deploymentException = (Exception)actionResult.getFailureResult()) == null) continue;
                throw deploymentException;
            }
        }
        return deployAction.getDeploymentUnitUniqueName();
    }
}

