/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.arquillian.domain;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.arquillian.container.spi.client.deployment.DeploymentDescription;
import org.jboss.arquillian.container.spi.event.container.BeforeDeploy;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.test.spi.TestClass;
import org.jboss.arquillian.test.spi.event.suite.AfterClass;
import org.jboss.arquillian.test.spi.event.suite.BeforeClass;
import org.jboss.shrinkwrap.api.Archive;
import org.wildfly.arquillian.domain.ServerGroupArchive;
import org.wildfly.arquillian.domain.api.TargetsServerGroup;
import org.wildfly.arquillian.domain.api.TargetsServerGroups;

public class ServerGroupDeploymentObserver {
    private final Map<String, Set<String>> serverGroupTargets = new HashMap<String, Set<String>>();

    public synchronized void setTargetServerGroups(@Observes BeforeDeploy event) {
        String deploymentName = event.getDeployment().getName();
        if (this.serverGroupTargets.containsKey(deploymentName)) {
            DeploymentDescription deploymentDescription = event.getDeployment();
            Archive delegate = deploymentDescription.getArchive();
            deploymentDescription.setTestableArchive(new ServerGroupArchive(delegate, Collections.unmodifiableSet(this.serverGroupTargets.get(deploymentName))));
        }
    }

    public synchronized void findTargetServerGroups(@Observes(precedence=100) BeforeClass event) {
        Method[] methods;
        TestClass testClass = event.getTestClass();
        for (Method method : methods = testClass.getMethods(Deployment.class)) {
            Deployment deployment;
            if (method.isAnnotationPresent(TargetsServerGroups.class)) {
                deployment = method.getAnnotation(Deployment.class);
                for (TargetsServerGroup target : method.getAnnotation(TargetsServerGroups.class).value()) {
                    this.add(deployment.name(), target.value());
                }
                continue;
            }
            if (!method.isAnnotationPresent(TargetsServerGroup.class)) continue;
            deployment = method.getAnnotation(Deployment.class);
            TargetsServerGroup target = method.getAnnotation(TargetsServerGroup.class);
            this.add(deployment.name(), target.value());
        }
    }

    public synchronized void removeTargertServerGroups(@Observes AfterClass event) {
        Method[] methods;
        TestClass testClass = event.getTestClass();
        for (Method method : methods = testClass.getMethods(Deployment.class)) {
            Deployment deployment = method.getAnnotation(Deployment.class);
            this.serverGroupTargets.remove(deployment.name());
        }
    }

    private void add(String deploymentName, String serverGroup) {
        Set<String> serverGroups = this.serverGroupTargets.get(deploymentName);
        if (serverGroups == null) {
            serverGroups = new LinkedHashSet<String>();
            this.serverGroupTargets.put(deploymentName, serverGroups);
        }
        serverGroups.add(serverGroup);
    }
}

