/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.api;

import java.io.IOException;
import java.util.function.Function;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.as.controller.client.Operation;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.dmr.ModelNode;
import org.wildfly.plugin.tools.OperationExecutionException;

public interface ServerSetupTask {
    public void setup(ManagementClient var1, String var2) throws Exception;

    public void tearDown(ManagementClient var1, String var2) throws Exception;

    default public ModelNode executeOperation(ManagementClient client, ModelNode op) throws IOException {
        return this.executeOperation(client, op, (ModelNode result) -> String.format("Failed to execute operation '%s': %s", op.asString(), Operations.getFailureDescription((ModelNode)result).asString()));
    }

    default public ModelNode executeOperation(ManagementClient client, ModelNode op, Function<ModelNode, String> errorMessage) throws IOException {
        return this.executeOperation(client, Operation.Factory.create((ModelNode)op), errorMessage);
    }

    default public ModelNode executeOperation(ManagementClient client, Operation op) throws IOException {
        return this.executeOperation(client, op, (ModelNode result) -> String.format("Failed to execute operation '%s': %s", op.getOperation().asString(), Operations.getFailureDescription((ModelNode)result).asString()));
    }

    default public ModelNode executeOperation(ManagementClient client, Operation op, Function<ModelNode, String> errorMessage) throws IOException {
        ModelNode result = client.getControllerClient().execute(op);
        if (!Operations.isSuccessfulOutcome((ModelNode)result)) {
            throw new OperationExecutionException(op, result);
        }
        return Operations.readResult((ModelNode)result);
    }
}

