/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.container;

import java.io.IOException;
import java.io.InputStream;
import java.net.DatagramSocket;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.CancellationException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.jboss.arquillian.container.spi.client.container.LifecycleException;
import org.jboss.as.arquillian.container.CommonContainerConfiguration;
import org.jboss.as.arquillian.container.CommonDeployableContainer;
import org.jboss.as.arquillian.container.CommonManagedContainerConfiguration;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.as.arquillian.container.PortAcquisitionTimeoutException;
import org.jboss.as.controller.client.helpers.Operations;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.wildfly.core.launcher.CommandBuilder;
import org.wildfly.core.launcher.Launcher;
import org.wildfly.core.launcher.ProcessHelper;
import org.wildfly.plugin.tools.server.ServerManager;
import org.wildfly.plugin.tools.server.StandaloneManager;

public abstract class CommonManagedDeployableContainer<T extends CommonManagedContainerConfiguration>
extends CommonDeployableContainer<T> {
    private static final int PORT_RANGE_MIN = 1;
    private static final int PORT_RANGE_MAX = 65535;
    private Thread shutdownThread = null;
    private Process process = null;
    private boolean timeoutSupported = false;

    @Override
    protected void startInternal() throws LifecycleException {
        CommonManagedContainerConfiguration config = (CommonManagedContainerConfiguration)this.getContainerConfiguration();
        if (this.isServerRunning(config)) {
            if (config.isAllowConnectingToRunningServer()) {
                StandaloneManager serverManager = ServerManager.builder().client(this.getManagementClient().getControllerClient()).process((ProcessHandle)ServerManager.findProcess().orElse(null)).standalone();
                this.serverManagerProducer.set((Object)serverManager.asManaged());
                return;
            }
            this.failDueToRunning(config);
        }
        try {
            CommandBuilder commandBuilder = this.createCommandBuilder(config);
            this.waitOnPorts(config);
            this.getLogger().info((Object)("Starting container with: " + commandBuilder.build()));
            Process process = Launcher.of((CommandBuilder)commandBuilder).setRedirectErrorStream(true).launch();
            new Thread(new ConsoleConsumer(process, config.isOutputToConsole())).start();
            this.shutdownThread = ProcessHelper.addShutdownHook((Process)process);
            StandaloneManager serverManager = ServerManager.builder().client(this.getManagementClient().getControllerClient()).process(process).standalone();
            long startupTimeout = config.getStartupTimeoutInSeconds();
            if (!serverManager.waitFor(startupTimeout, TimeUnit.SECONDS)) {
                ProcessHelper.destroyProcess((Process)process);
                throw new TimeoutException(String.format("Managed server was not started within [%d] s", startupTimeout));
            }
            this.timeoutSupported = this.isOperationAttributeSupported("shutdown", "timeout");
            this.process = process;
            this.serverManagerProducer.set((Object)serverManager.asManaged());
        }
        catch (LifecycleException e) {
            throw e;
        }
        catch (Exception e) {
            throw new LifecycleException("Could not start container", (Throwable)e);
        }
    }

    protected abstract CommandBuilder createCommandBuilder(T var1);

    protected abstract Logger getLogger();

    private void waitOnPorts(T config) throws PortAcquisitionTimeoutException {
        Integer[] ports = ((CommonManagedContainerConfiguration)config).getWaitForPorts();
        int timeoutInSeconds = ((CommonManagedContainerConfiguration)config).getWaitForPortsTimeoutInSeconds();
        if (ports != null && ports.length > 0) {
            Integer[] integerArray = ports;
            int n = integerArray.length;
            for (int i = 0; i < n; ++i) {
                int port = integerArray[i];
                long start = System.currentTimeMillis();
                while (!this.isPortAvailable(port)) {
                    int elapsedSeconds = (int)((System.currentTimeMillis() - start) / 1000L);
                    if (elapsedSeconds > timeoutInSeconds) {
                        throw new PortAcquisitionTimeoutException(port, timeoutInSeconds);
                    }
                    try {
                        TimeUnit.MILLISECONDS.sleep(500L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    this.getLogger().warnf("Waiting on port %d to become available for %ds", (Object)port, (Object)(timeoutInSeconds - elapsedSeconds));
                }
            }
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private boolean isPortAvailable(int port) {
        if (port < 1 || port > 65535) {
            throw new IllegalArgumentException("Port specified is out of range: " + port);
        }
        try (ServerSocket ss = new ServerSocket(port);){
            DatagramSocket ds = new DatagramSocket(port);
            try {
                ss.setReuseAddress(true);
                ds.setReuseAddress(true);
                boolean bl = true;
                ds.close();
                return bl;
            }
            catch (Throwable throwable) {
                try {
                    ds.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    protected void stopInternal(Integer timeout) throws LifecycleException {
        block17: {
            if (this.shutdownThread != null) {
                Runtime.getRuntime().removeShutdownHook(this.shutdownThread);
                this.shutdownThread = null;
            }
            Process process = this.process;
            this.process = null;
            try {
                int timeoutSeconds;
                if (process == null) break block17;
                Logger logger = this.getLogger();
                ModelNode op = Operations.createOperation((String)"shutdown");
                if (this.timeoutSupported) {
                    if (timeout != null) {
                        op.get("timeout").set(timeout.intValue());
                    }
                } else {
                    this.getLogger().error((Object)String.format("Timeout is not supported for %s on the shutdown operation.", this.getContainerDescription()));
                }
                if (process.isAlive()) {
                    ManagementClient client = this.getManagementClient();
                    if (client == null) {
                        logger.error((Object)"The management client does not seem to be active. Forcibly destroying the process.");
                        process.destroyForcibly();
                    } else {
                        String shutdownFailureMessage = null;
                        try {
                            ModelNode result = client.getControllerClient().execute(op);
                            if (!Operations.isSuccessfulOutcome((ModelNode)result)) {
                                shutdownFailureMessage = Operations.getFailureDescription((ModelNode)result).asString();
                            }
                        }
                        catch (IOException | CancellationException e) {
                            if (e instanceof CancellationException || e.getCause() instanceof CancellationException) {
                                shutdownFailureMessage = e.toString();
                            }
                            throw e;
                        }
                        if (shutdownFailureMessage != null) {
                            logger.errorf("Failed to shutdown the server: %s", (Object)shutdownFailureMessage);
                            process.destroyForcibly();
                        }
                    }
                }
                if (!process.waitFor(timeoutSeconds = ((CommonManagedContainerConfiguration)this.getContainerConfiguration()).getStartupTimeoutInSeconds(), TimeUnit.SECONDS)) {
                    logger.warnf("The container process did not exit within %d seconds. Forcibly destroying the process.", (Object)timeoutSeconds);
                    process.destroyForcibly();
                }
            }
            catch (Exception e) {
                try {
                    ProcessHelper.destroyProcess((Process)process);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw new LifecycleException("Could not stop container", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isServerRunning(T config) {
        Socket socket = null;
        try {
            socket = new Socket(((CommonContainerConfiguration)config).getManagementAddress(), ((CommonContainerConfiguration)config).getManagementPort());
        }
        catch (Exception ignored) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not close isServerStarted socket", e);
                }
            }
        }
        return true;
    }

    private void failDueToRunning(T config) throws LifecycleException {
        int managementPort = ((CommonContainerConfiguration)config).getManagementPort();
        throw new LifecycleException(String.format("The port %1$d is already in use. It means that either the server might be already running or there is another process using port %1$d.%nManaged containers do not support connecting to running server instances due to the possible harmful effect of connecting to the wrong server.%nPlease stop server (or another process) before running, change to another type of container (e.g. remote) or use jboss.socket.binding.port-offset variable to change the default port.%nTo disable this check and allow Arquillian to connect to a running server, set allowConnectingToRunningServer to true in the container configuration", managementPort));
    }

    private static class ConsoleConsumer
    implements Runnable {
        private final Process process;
        private final boolean writeOutput;

        private ConsoleConsumer(Process process, boolean writeOutput) {
            this.process = process;
            this.writeOutput = writeOutput;
        }

        @Override
        public void run() {
            InputStream stream = this.process.getInputStream();
            try {
                int num;
                byte[] buf = new byte[32];
                while ((num = stream.read(buf)) != -1) {
                    if (!this.writeOutput) continue;
                    System.out.write(buf, 0, num);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

