/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.container;

import java.util.List;
import java.util.Map;
import org.jboss.arquillian.container.spi.Container;
import org.jboss.arquillian.container.spi.ContainerRegistry;
import org.jboss.arquillian.container.test.spi.TestDeployment;
import org.jboss.arquillian.container.test.spi.client.deployment.ProtocolArchiveProcessor;
import org.jboss.arquillian.core.api.Instance;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.as.arquillian.container.WildFlyArquillianConfiguration;
import org.jboss.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;

public class WildFlyProtocolArchiveProcessor
implements ProtocolArchiveProcessor {
    private static final Logger LOGGER = Logger.getLogger(WildFlyProtocolArchiveProcessor.class);
    @Inject
    private Instance<ContainerRegistry> containerRegistry;

    public void process(TestDeployment testDeployment, Archive<?> protocolArchive) {
        Container<?> container = this.findContainer(testDeployment.getTargetDescription().getName());
        if (container == null) {
            LOGGER.debugf("Could not find a container named %s", (Object)testDeployment.getTargetDescription().getName());
            return;
        }
        Map config = container.getContainerConfiguration().getContainerProperties();
        WildFlyArquillianConfiguration.addConfiguration(config, protocolArchive);
    }

    private Container<?> findContainer(String targetName) {
        ContainerRegistry registry = (ContainerRegistry)this.containerRegistry.get();
        if (registry == null) {
            return null;
        }
        List containers = registry.getContainers();
        if (containers.size() == 1) {
            return (Container)containers.get(0);
        }
        if ("_DEFAULT_".equals(targetName)) {
            for (Container container : containers) {
                if (!container.getContainerConfiguration().isDefault()) continue;
                return container;
            }
        }
        return registry.getContainer(targetName);
    }
}

