/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.container.embedded;

import org.jboss.arquillian.container.spi.ConfigurationException;
import org.jboss.arquillian.container.spi.client.deployment.Validate;
import org.jboss.as.arquillian.container.CommonContainerConfiguration;

public class EmbeddedContainerConfiguration
extends CommonContainerConfiguration {
    private String jbossHome = System.getenv("JBOSS_HOME");
    private String modulePath = System.getProperty("module.path");
    private String cleanServerBaseDir = System.getProperty("jboss.embedded.root");

    public EmbeddedContainerConfiguration() {
        if (this.jbossHome == null || this.jbossHome.isEmpty()) {
            this.jbossHome = System.getProperty("jboss.home");
        }
        if ((this.modulePath == null || this.modulePath.isEmpty()) && this.jbossHome != null) {
            this.modulePath = this.jbossHome + "/modules";
        }
    }

    public String getJbossHome() {
        return this.jbossHome;
    }

    public void setJbossHome(String jbossHome) {
        this.jbossHome = jbossHome;
    }

    public String getModulePath() {
        return this.modulePath;
    }

    public void setModulePath(String modulePath) {
        this.modulePath = modulePath;
    }

    public String getCleanServerBaseDir() {
        return this.cleanServerBaseDir;
    }

    public void setCleanServerBaseDir(String cleanServerBaseDir) {
        this.cleanServerBaseDir = cleanServerBaseDir;
    }

    public void validate() throws ConfigurationException {
        super.validate();
        Validate.configurationDirectoryExists((String)this.jbossHome, (String)("jbossHome '" + this.jbossHome + "' must exist"));
        Validate.configurationDirectoryExists((String)this.modulePath, (String)("modulePath '" + this.modulePath + "' must exist"));
    }
}

