/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.container.managed;

import org.jboss.arquillian.container.spi.ConfigurationException;
import org.jboss.as.arquillian.container.DistributionContainerConfiguration;

public class ManagedContainerConfiguration
extends DistributionContainerConfiguration {
    private String javaVmArguments = System.getProperty("jboss.options");
    private String jbossArguments;
    private String moduleOptions;
    private boolean debug = ManagedContainerConfiguration.getBooleanProperty("wildfly.debug", false);
    private int debugPort = Integer.parseInt(System.getProperty("wildfly.debug.port", "8787"));
    private boolean debugSuspend = ManagedContainerConfiguration.getBooleanProperty("wildfly.debug.suspend", true);
    private String serverConfig = System.getProperty("jboss.server.config.file.name");
    private String readOnlyServerConfig = System.getProperty("jboss.server.config.file.name.readonly");
    private boolean enableAssertions = true;
    private boolean adminOnly = false;
    private boolean setupCleanServerBaseDir = false;
    private String cleanServerBaseDir;
    private String yamlConfiguration;

    public void validate() throws ConfigurationException {
        super.validate();
        if (this.serverConfig != null && this.readOnlyServerConfig != null) {
            throw new ConfigurationException(String.format("Cannot define both a serverConfig and a readOnlyServerConfig: serverConfig=%s - readOnlyServerConfig=%s", this.serverConfig, this.readOnlyServerConfig));
        }
    }

    public String getJavaVmArguments() {
        return this.javaVmArguments;
    }

    public void setJavaVmArguments(String javaVmArguments) {
        this.javaVmArguments = javaVmArguments;
    }

    public String getJbossArguments() {
        return this.jbossArguments;
    }

    public void setJbossArguments(String jbossArguments) {
        this.jbossArguments = jbossArguments;
    }

    public String getModuleOptions() {
        return this.moduleOptions;
    }

    public void setModuleOptions(String moduleOptions) {
        this.moduleOptions = moduleOptions;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public int getDebugPort() {
        return this.debugPort;
    }

    public void setDebugPort(int debugPort) {
        this.debugPort = debugPort;
    }

    public boolean isDebugSuspend() {
        return this.debugSuspend;
    }

    public void setDebugSuspend(boolean debugSuspend) {
        this.debugSuspend = debugSuspend;
    }

    public String getServerConfig() {
        return this.serverConfig;
    }

    public void setServerConfig(String serverConfig) {
        this.serverConfig = serverConfig;
    }

    public String getReadOnlyServerConfig() {
        return this.readOnlyServerConfig;
    }

    public void setReadOnlyServerConfig(String serverConfig) {
        this.readOnlyServerConfig = serverConfig;
    }

    public boolean isEnableAssertions() {
        return this.enableAssertions;
    }

    public void setEnableAssertions(boolean enableAssertions) {
        this.enableAssertions = enableAssertions;
    }

    public boolean isAdminOnly() {
        return this.adminOnly;
    }

    public void setAdminOnly(boolean adminOnly) {
        this.adminOnly = adminOnly;
    }

    public boolean isSetupCleanServerBaseDir() {
        return this.setupCleanServerBaseDir;
    }

    public void setSetupCleanServerBaseDir(boolean setupCleanServerBaseDir) {
        this.setupCleanServerBaseDir = setupCleanServerBaseDir;
    }

    public String getCleanServerBaseDir() {
        return this.cleanServerBaseDir;
    }

    public void setCleanServerBaseDir(String cleanServerBaseDir) {
        this.cleanServerBaseDir = cleanServerBaseDir;
    }

    public String getYamlConfiguration() {
        return this.yamlConfiguration;
    }

    public void setYamlConfiguration(String yamlConfiguration) {
        if (yamlConfiguration != null && !yamlConfiguration.isBlank()) {
            this.yamlConfiguration = yamlConfiguration;
        }
    }

    private static boolean getBooleanProperty(String key, boolean dft) {
        String value = System.getProperty(key);
        if (value != null) {
            return value.isBlank() || Boolean.parseBoolean(value);
        }
        return dft;
    }
}

