/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.arquillian.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import org.jboss.arquillian.container.test.spi.util.ServiceLoader;
import org.jboss.arquillian.testenricher.msc.ServiceTargetAssociation;
import org.jboss.as.arquillian.service.ArquillianConfigServiceCustomizer;
import org.jboss.as.arquillian.service.ArquillianService;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.modules.Module;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;

public final class ArquillianConfig
implements Service {
    private final List<ArquillianConfigServiceCustomizer> serviceCustomizers = new ArrayList<ArquillianConfigServiceCustomizer>();
    private final Supplier<ArquillianService> arquillianServiceSupplier;
    private final Supplier<DeploymentUnit> deploymentUnitSupplier;
    private final ServiceName serviceName;
    private final List<String> testClasses = new ArrayList<String>();

    ArquillianConfig(ServiceName serviceName, Set<String> testClasses, Supplier<ArquillianService> arquillianServiceSupplier, Supplier<DeploymentUnit> deploymentUnitSupplier) {
        this.serviceName = serviceName;
        this.testClasses.addAll(testClasses);
        this.arquillianServiceSupplier = arquillianServiceSupplier;
        this.deploymentUnitSupplier = deploymentUnitSupplier;
        for (ArquillianConfigServiceCustomizer customizer : ServiceLoader.load(ArquillianConfigServiceCustomizer.class)) {
            this.serviceCustomizers.add(customizer);
        }
    }

    void addDeps(ServiceBuilder<ArquillianConfig> builder, ServiceController<?> depController) {
        for (ArquillianConfigServiceCustomizer customizer : this.serviceCustomizers) {
            customizer.customizeService(this, builder, depController);
        }
    }

    DeploymentUnit getDeploymentUnit() {
        return this.deploymentUnitSupplier.get();
    }

    ServiceName getServiceName() {
        return this.serviceName;
    }

    List<String> getTestClasses() {
        return Collections.unmodifiableList(this.testClasses);
    }

    Class<?> loadClass(String className) throws ClassNotFoundException {
        if (!this.testClasses.contains(className)) {
            throw new ClassNotFoundException("Class '" + className + "' not found in: " + this.testClasses);
        }
        Module module = (Module)this.deploymentUnitSupplier.get().getAttachment(Attachments.MODULE);
        Class testClass = module.getClassLoader().loadClass(className);
        for (ArquillianConfigServiceCustomizer customizer : this.serviceCustomizers) {
            customizer.customizeLoadClass(this.deploymentUnitSupplier.get(), testClass);
        }
        return testClass;
    }

    public void start(StartContext context) {
        this.arquillianServiceSupplier.get().registerArquillianConfig(this);
        for (String testClass : this.testClasses) {
            ServiceTargetAssociation.setServiceTarget((String)testClass, (ServiceTarget)context.getChildTarget());
        }
    }

    public void stop(StopContext context) {
        context.getController().setMode(ServiceController.Mode.REMOVE);
        this.arquillianServiceSupplier.get().unregisterArquillianConfig(this);
        for (String testClass : this.testClasses) {
            ServiceTargetAssociation.clearServiceTarget((String)testClass);
        }
    }

    public String toString() {
        String uname = this.serviceName.getSimpleName();
        String sname = this.serviceName.getCanonicalName();
        return "ArquillianConfig[service=" + sname + ",unit=" + uname + ",tests=" + this.testClasses + "]";
    }
}

