/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.testing.tools.deployments;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.ByteArrayAsset;
import org.jboss.shrinkwrap.api.container.WebContainer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.wildfly.testing.tools.xml.CloseableXMLStreamWriter;
import org.xml.sax.SAXException;

public class DeploymentDescriptors {
    private DeploymentDescriptors() {
    }

    public static <T extends WebContainer<T> & Archive<T>> T addJBossDeploymentStructure(T archive, Set<String> addedModules, Set<String> excludedModules) {
        return (T)((WebContainer)archive.addAsWebInfResource(DeploymentDescriptors.createJBossDeploymentStructureAsset(addedModules, excludedModules), "jboss-deployment-structure.xml"));
    }

    public static Asset createJBossDeploymentStructureAsset(Set<String> addedModules, Set<String> excludedModules) {
        return new ByteArrayAsset(DeploymentDescriptors.createJBossDeploymentStructure(addedModules, excludedModules));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static byte[] createJBossDeploymentStructure(Set<String> addedModules, Set<String> excludedModules) {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            Object object;
            block17: {
                CloseableXMLStreamWriter writer = CloseableXMLStreamWriter.of(out);
                try {
                    writer.writeStartDocument("utf-8", "1.0");
                    writer.writeStartElement("jboss-deployment-structure");
                    writer.writeStartElement("deployment");
                    if (!addedModules.isEmpty()) {
                        writer.writeStartElement("dependencies");
                        for (String module : addedModules) {
                            writer.writeStartElement("module");
                            writer.writeAttribute("name", module);
                            writer.writeEndElement();
                        }
                        writer.writeEndElement();
                    }
                    if (!excludedModules.isEmpty()) {
                        writer.writeStartElement("exclusions");
                        for (String module : addedModules) {
                            writer.writeStartElement("module");
                            writer.writeAttribute("name", module);
                            writer.writeEndElement();
                        }
                        writer.writeEndElement();
                    }
                    writer.writeEndElement();
                    writer.writeEndElement();
                    writer.writeEndDocument();
                    writer.flush();
                    object = out.toByteArray();
                    if (writer == null) break block17;
                }
                catch (Throwable throwable) {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                writer.close();
            }
            return object;
        }
        catch (IOException | XMLStreamException e) {
            throw new RuntimeException("Failed to create the jboss-deployment-structure.xml file.", e);
        }
    }

    public static Asset createJBossWebContextRoot(String contextRoot) {
        return DeploymentDescriptors.createJBossWebXmlAsset(Map.of("context-root", contextRoot));
    }

    public static Asset createJBossWebSecurityDomain(String securityDomain) {
        return DeploymentDescriptors.createJBossWebXmlAsset(Map.of("security-domain", securityDomain));
    }

    public static Asset createJBossWebXmlAsset(Map<String, String> elements) {
        return new ByteArrayAsset(DeploymentDescriptors.createJBossWebXml(elements));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static byte[] createJBossWebXml(Map<String, String> elements) {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            Object object;
            block14: {
                CloseableXMLStreamWriter writer = CloseableXMLStreamWriter.of(out);
                try {
                    writer.writeStartDocument("utf-8", "1.0");
                    writer.writeStartElement("jboss-web");
                    for (Map.Entry<String, String> element : elements.entrySet()) {
                        writer.writeStartElement(element.getKey());
                        writer.writeCharacters(element.getValue());
                        writer.writeEndElement();
                    }
                    writer.writeEndElement();
                    writer.writeEndDocument();
                    writer.flush();
                    object = out.toByteArray();
                    if (writer == null) break block14;
                }
                catch (Throwable throwable) {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                writer.close();
            }
            return object;
        }
        catch (IOException | XMLStreamException e) {
            throw new RuntimeException("Failed to create the jboss-deployment-structure.xml file.", e);
        }
    }

    public static Asset createPermissionsXmlAsset(Permission ... permissions) {
        return new ByteArrayAsset(DeploymentDescriptors.createPermissionsXml(permissions));
    }

    public static Asset createPermissionsXmlAsset(Iterable<? extends Permission> permissions, Permission ... additionalPermissions) {
        return new ByteArrayAsset(DeploymentDescriptors.createPermissionsXml(permissions, additionalPermissions));
    }

    public static Asset createPermissionsXmlAsset(Iterable<? extends Permission> permissions) {
        return new ByteArrayAsset(DeploymentDescriptors.createPermissionsXml(permissions, new Permission[0]));
    }

    public static byte[] createPermissionsXml(Permission ... permissions) {
        return DeploymentDescriptors.createPermissionsXml(List.of(permissions), new Permission[0]);
    }

    public static byte[] createPermissionsXml(Iterable<? extends Permission> permissions, Permission ... additionalPermissions) {
        LinkedHashSet<PermissionDescription> allPermissions = new LinkedHashSet<PermissionDescription>();
        permissions.forEach(permission -> allPermissions.add(PermissionDescription.of(permission)));
        allPermissions.addAll(Stream.of(additionalPermissions).map(PermissionDescription::of).collect(Collectors.toSet()));
        return DeploymentDescriptors.createPermissionsXml(allPermissions);
    }

    public static Asset appendPermissions(Asset currentPermissions, Permission ... permissions) {
        LinkedHashSet orderedPermissions = new LinkedHashSet();
        Collections.addAll(orderedPermissions, permissions);
        return DeploymentDescriptors.appendPermissions(currentPermissions, orderedPermissions);
    }

    public static Asset appendPermissions(Asset currentPermissions, Iterable<? extends Permission> permissions) {
        LinkedHashSet<PermissionDescription> allPermissions = new LinkedHashSet<PermissionDescription>();
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            try (InputStream in = currentPermissions.openStream();){
                Document doc = builder.parse(in);
                Element root = doc.getDocumentElement();
                NodeList xmlPermissions = root.getElementsByTagName("permission");
                for (int i = 0; i < xmlPermissions.getLength(); ++i) {
                    Node permission = xmlPermissions.item(i);
                    String className = null;
                    String name = null;
                    String actions = null;
                    if (permission.hasChildNodes()) {
                        NodeList children = permission.getChildNodes();
                        for (int j = 0; j < children.getLength(); ++j) {
                            Node child = children.item(j);
                            if (child.getNodeType() != 1) continue;
                            if (child.getNodeName().equals("class-name")) {
                                className = child.getTextContent();
                                continue;
                            }
                            if (child.getNodeName().equals("name")) {
                                name = child.getTextContent();
                                continue;
                            }
                            if (!child.getNodeName().equals("actions")) continue;
                            actions = child.getTextContent();
                        }
                    }
                    if (className == null) continue;
                    allPermissions.add(new PermissionDescription(className, name, actions));
                }
            }
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new RuntimeException("Failed to append permissions.xml file.", e);
        }
        permissions.forEach(p -> allPermissions.add(PermissionDescription.of(p)));
        return new ByteArrayAsset(DeploymentDescriptors.createPermissionsXml(allPermissions));
    }

    public static Collection<Permission> addModuleFilePermission(String ... moduleNames) {
        String value = System.getProperty("module.jar.path");
        if (value == null || value.isBlank()) {
            return Collections.emptySet();
        }
        Path moduleDir = Path.of(value, new String[0]);
        ArrayList<Permission> result = new ArrayList<Permission>();
        for (String moduleName : moduleNames) {
            Path definedModuleDir = moduleDir.resolve(moduleName.replace('.', File.separatorChar)).resolve("main");
            try (Stream<Path> stream = Files.walk(definedModuleDir, new FileVisitOption[0]);){
                stream.filter(path -> path.getFileName().toString().endsWith(".jar")).map(path -> new FilePermission(path.toAbsolutePath().toString(), "read")).forEach(result::add);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        return result;
    }

    public static Collection<FilePermission> createTempDirPermission(String actions) {
        Object tempDir = System.getProperty("java.io.tmpdir");
        if (((String)tempDir).charAt(((String)tempDir).length() - 1) != File.separatorChar) {
            tempDir = (String)tempDir + File.separatorChar;
        }
        return List.of(new FilePermission((String)tempDir, "read"), new FilePermission((String)tempDir + "-", actions));
    }

    private static void addPermissionXml(XMLStreamWriter writer, Iterable<? extends PermissionDescription> permissions) throws XMLStreamException {
        for (PermissionDescription permissionDescription : permissions) {
            writer.writeStartElement("permission");
            writer.writeStartElement("class-name");
            writer.writeCharacters(permissionDescription.className);
            writer.writeEndElement();
            writer.writeStartElement("name");
            writer.writeCharacters(permissionDescription.name);
            writer.writeEndElement();
            String actions = permissionDescription.actions;
            if (actions != null && !actions.isEmpty()) {
                writer.writeStartElement("actions");
                writer.writeCharacters(actions);
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static byte[] createPermissionsXml(Set<PermissionDescription> permissions) {
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            byte[] byArray;
            block13: {
                CloseableXMLStreamWriter writer = CloseableXMLStreamWriter.of(out);
                try {
                    writer.writeStartDocument("utf-8", "1.0");
                    writer.writeStartElement("permissions");
                    writer.writeNamespace(null, "https://jakarta.ee/xml/ns/jakartaee");
                    writer.writeAttribute("version", "10");
                    DeploymentDescriptors.addPermissionXml(writer, permissions);
                    writer.writeEndElement();
                    writer.writeEndDocument();
                    writer.flush();
                    byArray = out.toByteArray();
                    if (writer == null) break block13;
                }
                catch (Throwable throwable) {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                writer.close();
            }
            return byArray;
        }
        catch (IOException | XMLStreamException e) {
            throw new RuntimeException("Failed to create the permissions.xml file.", e);
        }
    }

    private static class PermissionDescription {
        private final String className;
        private final String name;
        private final String actions;

        private PermissionDescription(String className, String name, String actions) {
            this.className = className;
            this.name = name;
            this.actions = actions;
        }

        static PermissionDescription of(Permission permission) {
            return new PermissionDescription(permission.getClass().getName(), permission.getName(), permission.getActions());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof PermissionDescription)) {
                return false;
            }
            PermissionDescription other = (PermissionDescription)obj;
            return Objects.equals(this.className, other.className) && Objects.equals(this.name, other.name) && Objects.equals(this.actions, other.actions);
        }

        public int hashCode() {
            return Objects.hash(this.className, this.name, this.actions);
        }

        public String toString() {
            return "PermissionDescription[className=" + this.className + ", name=" + this.name + ", actions=" + this.actions + "]";
        }
    }
}

