/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.build.plugin;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.RemoteRepository;
import org.wildfly.build.AetherArtifactFileResolver;
import org.wildfly.build.ArtifactFileResolver;
import org.wildfly.build.featurepack.FeaturePackBuilder;
import org.wildfly.build.featurepack.model.FeaturePackBuild;
import org.wildfly.build.featurepack.model.FeaturePackBuildModelParser;
import org.wildfly.build.plugin.MavenProjectArtifactResolver;
import org.wildfly.build.util.FileUtils;
import org.wildfly.build.util.MapPropertyResolver;
import org.wildfly.build.util.PropertyResolver;

@Mojo(name="build", requiresDependencyResolution=ResolutionScope.RUNTIME, defaultPhase=LifecyclePhase.COMPILE)
public class FeaturePackBuildMojo
extends AbstractMojo {
    private static final boolean OS_WINDOWS = System.getProperty("os.name").contains("indows");
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(alias="config-file", property="wildfly.feature.pack.configFile")
    private String configFile;
    @Parameter(alias="config-dir", defaultValue="${basedir}", property="wildfly.feature.pack.configDir")
    private File configDir;
    @Parameter(alias="server-name", defaultValue="${project.build.finalName}", property="wildfly.feature.pack.serverName")
    private String serverName;
    @Parameter(defaultValue="${project.build.directory}", property="wildfly.feature.pack.buildName")
    private String buildName;
    @Component
    private RepositorySystem repoSystem;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    private RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true)
    private List<RemoteRepository> remoteRepos;

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.copyContents();
        try (FileInputStream configStream = new FileInputStream(new File(this.configDir, this.configFile));){
            Properties properties = new Properties();
            properties.putAll((Map<?, ?>)this.project.getProperties());
            properties.putAll((Map<?, ?>)System.getProperties());
            properties.put("project.version", this.project.getVersion());
            FeaturePackBuild build = new FeaturePackBuildModelParser((PropertyResolver)new MapPropertyResolver(properties)).parse(configStream);
            File target = new File(this.buildName, this.serverName);
            FeaturePackBuilder.build(build, target, new MavenProjectArtifactResolver(this.project), (ArtifactFileResolver)new AetherArtifactFileResolver(this.repoSystem, this.repoSession, this.remoteRepos));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void copyContents() {
        try {
            File baseDir = new File(this.buildName, this.serverName);
            FileUtils.deleteRecursive((File)baseDir);
            Path path = Paths.get(baseDir.getAbsolutePath(), new String[0]);
            Path baseFile = Paths.get(this.configDir.getAbsolutePath() + "/src/main/resources", new String[0]);
            this.doCopy(path.resolve("content"), baseFile.resolve("content"));
            this.doCopy(path.resolve("modules"), baseFile.resolve("modules"));
            this.doCopy(path.resolve("configuration"), baseFile.resolve("configuration"));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void doCopy(final Path target, final Path source) throws IOException {
        Files.walkFileTree(source, (FileVisitor<? super Path>)new FileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                String relative = source.relativize(dir).toString();
                boolean include = true;
                if (include) {
                    Path rel = target.resolve(relative);
                    if (!Files.isDirectory(rel, new LinkOption[0]) && !rel.toFile().mkdirs()) {
                        throw new IOException("Could not create directory " + rel.toString());
                    }
                    return FileVisitResult.CONTINUE;
                }
                return FileVisitResult.SKIP_SUBTREE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                String relative = source.relativize(file).toString();
                Path targetFile = target.resolve(relative);
                FileUtils.copyFile((File)file.toFile(), (File)targetFile.toFile());
                if (!OS_WINDOWS) {
                    Files.setPosixFilePermissions(targetFile, Files.getPosixFilePermissions(file, new LinkOption[0]));
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                return FileVisitResult.TERMINATE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                return FileVisitResult.CONTINUE;
            }
        });
    }
}

