/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.build.plugin;

import java.util.HashMap;
import java.util.Map;
import org.apache.maven.project.MavenProject;
import org.wildfly.build.ArtifactResolver;
import org.wildfly.build.pack.model.Artifact;

public class MavenProjectArtifactResolver
implements ArtifactResolver {
    private final Map<String, Artifact> artifactMap = new HashMap<String, Artifact>();

    public MavenProjectArtifactResolver(MavenProject mavenProject) {
        for (org.apache.maven.artifact.Artifact mavenProjectArtifact : mavenProject.getArtifacts()) {
            Artifact artifact = new Artifact(mavenProjectArtifact.getGroupId(), mavenProjectArtifact.getArtifactId(), mavenProjectArtifact.getClassifier(), mavenProjectArtifact.getType(), mavenProjectArtifact.getVersion());
            StringBuilder sb = new StringBuilder();
            sb.append(artifact.getGACE().getGroupId());
            sb.append(':');
            sb.append(artifact.getGACE().getArtifactId());
            if (artifact.getGACE().getClassifier() != null && !artifact.getGACE().getClassifier().isEmpty()) {
                this.artifactMap.put(sb.append("::").append(artifact.getGACE().getClassifier()).toString(), artifact);
                continue;
            }
            this.artifactMap.put(sb.toString(), artifact);
        }
    }

    public Artifact getArtifact(String artifactCoords) {
        return this.artifactMap.get(artifactCoords);
    }

    public Artifact getArtifact(Artifact.GACE GACE2) {
        StringBuilder sb = new StringBuilder();
        sb.append(GACE2.getGroupId());
        sb.append(':');
        sb.append(GACE2.getArtifactId());
        if (GACE2.getClassifier() != null) {
            sb.append("::").append(GACE2.getClassifier());
        }
        return this.getArtifact(sb.toString());
    }
}

