/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.build.plugin;

import java.util.HashMap;
import java.util.Map;
import org.apache.maven.model.Dependency;
import org.apache.maven.project.MavenProject;
import org.jboss.logging.Logger;
import org.wildfly.build.ArtifactResolver;
import org.wildfly.build.pack.model.Artifact;

public class MavenProjectArtifactResolver
implements ArtifactResolver {
    private static final Logger logger = Logger.getLogger(MavenProjectArtifactResolver.class);
    private final Map<String, Artifact> artifactMap = new HashMap<String, Artifact>();

    public MavenProjectArtifactResolver(MavenProject mavenProject) {
        Artifact artifact;
        if (mavenProject.getDependencyManagement() != null) {
            for (Dependency dependency : mavenProject.getDependencyManagement().getDependencies()) {
                artifact = new Artifact(dependency.getGroupId(), dependency.getArtifactId(), dependency.getType(), dependency.getClassifier(), dependency.getVersion());
                this.artifactMap.put(new Artifact(artifact, null).toString(), artifact);
                logger.debug((Object)("Adding dependencymanagement: " + artifact.toJBossModulesString()));
            }
        }
        for (org.apache.maven.artifact.Artifact mavenProjectArtifact : mavenProject.getArtifacts()) {
            artifact = new Artifact(mavenProjectArtifact.getGroupId(), mavenProjectArtifact.getArtifactId(), mavenProjectArtifact.getType(), mavenProjectArtifact.getClassifier(), mavenProjectArtifact.getVersion());
            this.artifactMap.put(new Artifact(artifact, null).toString(), artifact);
            logger.debug((Object)("Adding dependency: " + artifact.toJBossModulesString()));
        }
    }

    public Artifact getArtifact(Artifact GACE) {
        return this.artifactMap.get(GACE.toString());
    }
}

