/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.build.provisioning;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.wildfly.build.pack.model.Artifact;
import org.wildfly.build.provisioning.ProvisionCommand;
import org.wildfly.build.provisioning.model.ServerProvisioningDescription;
import org.wildfly.build.provisioning.model.ServerProvisioningDescriptionXmlWriter;

public class CreateCommand {
    public static void createServer(String[] args) {
        String file = "server-provisioning.xml";
        ArrayList<FeaturePack> packs = new ArrayList<FeaturePack>();
        boolean lastCommandPack = false;
        boolean noProvision = false;
        block12: for (int i = 0; i < args.length; ++i) {
            String arg;
            switch (arg = args[i]) {
                case "--pack": {
                    if (++i == args.length) {
                        CreateCommand.printUsageAndExit(1);
                    }
                    packs.add(new FeaturePack(Artifact.parse(args[i])));
                    lastCommandPack = true;
                    continue block12;
                }
                case "--subsystems": {
                    if (!lastCommandPack) {
                        CreateCommand.printUsageAndExit(1);
                    }
                    if (++i == args.length) {
                        CreateCommand.printUsageAndExit(1);
                    }
                    String[] subsystems = args[i].split(",");
                    ((FeaturePack)packs.get((int)(packs.size() - 1))).subsystems.addAll(Arrays.asList(subsystems));
                    lastCommandPack = false;
                    continue block12;
                }
                case "--file": {
                    if (++i == args.length) {
                        CreateCommand.printUsageAndExit(1);
                    }
                    file = args[i];
                    lastCommandPack = false;
                    continue block12;
                }
                case "--no-provision": {
                    noProvision = true;
                    lastCommandPack = false;
                }
            }
        }
        if (packs.isEmpty()) {
            CreateCommand.printUsageAndExit(1);
        }
        CreateCommand.doCreate(packs, file);
        if (!noProvision) {
            ProvisionCommand.provision(new File(file));
        }
    }

    private static void doCreate(List<FeaturePack> packs, String file) {
        ServerProvisioningDescription description = new ServerProvisioningDescription();
        for (FeaturePack pack : packs) {
            ArrayList<ServerProvisioningDescription.FeaturePack.Subsystem> subsystems = new ArrayList<ServerProvisioningDescription.FeaturePack.Subsystem>();
            for (String subsystem : pack.subsystems) {
                subsystems.add(new ServerProvisioningDescription.FeaturePack.Subsystem(subsystem, true));
            }
            description.getFeaturePacks().add(new ServerProvisioningDescription.FeaturePack(pack.name, null, null, null, subsystems));
        }
        try {
            ServerProvisioningDescriptionXmlWriter.INSTANCE.writeContent(new File(file), description);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void printUsageAndExit(int exitCode) {
        System.out.print("TODO: usage");
        System.exit(exitCode);
    }

    private static class FeaturePack {
        final Artifact name;
        final List<String> subsystems = new ArrayList<String>();

        private FeaturePack(Artifact name) {
            this.name = name;
        }
    }
}

