/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.build.pack.model;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.wildfly.build.common.model.ConfigModelParser11;
import org.wildfly.build.common.model.CopyArtifactsModelParser10;
import org.wildfly.build.common.model.FileFilterModelParser10;
import org.wildfly.build.common.model.FilePermissionsModelParser10;
import org.wildfly.build.pack.model.Artifact;
import org.wildfly.build.pack.model.FeaturePackDescription;
import org.wildfly.build.util.BuildPropertyReplacer;
import org.wildfly.build.util.PropertyResolver;
import org.wildfly.build.util.xml.ParsingUtils;

class FeaturePackDescriptionXMLParser11
implements XMLElementReader<FeaturePackDescription> {
    public static final String NAMESPACE_1_1 = "urn:wildfly:feature-pack:1.1";
    private final BuildPropertyReplacer propertyReplacer;
    private final ConfigModelParser11 configModelParser;
    private final CopyArtifactsModelParser10 copyArtifactsModelParser;
    private final FilePermissionsModelParser10 filePermissionsModelParser;

    FeaturePackDescriptionXMLParser11(PropertyResolver resolver) {
        this.propertyReplacer = new BuildPropertyReplacer(resolver);
        this.configModelParser = new ConfigModelParser11(this.propertyReplacer);
        FileFilterModelParser10 fileFilterModelParser = new FileFilterModelParser10(this.propertyReplacer);
        this.copyArtifactsModelParser = new CopyArtifactsModelParser10(this.propertyReplacer, fileFilterModelParser);
        this.filePermissionsModelParser = new FilePermissionsModelParser10(this.propertyReplacer, fileFilterModelParser);
    }

    @Override
    public void readElement(XMLExtendedStreamReader reader, FeaturePackDescription result) throws XMLStreamException {
        EnumSet<Attribute> required = EnumSet.noneOf(Attribute.class);
        int i = 0;
        int count = reader.getAttributeCount();
        if (i < count) {
            throw ParsingUtils.unexpectedContent(reader);
        }
        if (!required.isEmpty()) {
            throw ParsingUtils.missingAttributes(reader.getLocation(), required);
        }
        block11: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case DEPENDENCIES: {
                            this.parseDependencies(reader, result);
                            continue block11;
                        }
                        case ARTIFACT_VERSIONS: {
                            this.parseArtifactVersions(reader, result);
                            continue block11;
                        }
                        case CONFIG: {
                            this.configModelParser.parseConfig(reader, result.getConfig());
                            continue block11;
                        }
                        case COPY_ARTIFACTS: {
                            this.copyArtifactsModelParser.parseCopyArtifacts(reader, result.getCopyArtifacts());
                            continue block11;
                        }
                        case FILE_PERMISSIONS: {
                            this.filePermissionsModelParser.parseFilePermissions(reader, result.getFilePermissions());
                            continue block11;
                        }
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    private void parseDependencies(XMLStreamReader reader, FeaturePackDescription result) throws XMLStreamException {
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case ARTIFACT: {
                            result.getDependencies().add(this.parseName(reader));
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    private String parseName(XMLStreamReader reader) throws XMLStreamException {
        int count = reader.getAttributeCount();
        String name = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.NAME);
        block3: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case NAME: {
                    name = reader.getAttributeValue(i);
                    continue block3;
                }
                default: {
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParsingUtils.missingAttributes(reader.getLocation(), required);
        }
        ParsingUtils.parseNoContent(reader);
        return this.propertyReplacer.replaceProperties(name);
    }

    private void parseArtifactVersions(XMLStreamReader reader, FeaturePackDescription result) throws XMLStreamException {
        Set<Artifact> artifactVersions = result.getArtifactVersions();
        block7: while (reader.hasNext()) {
            switch (reader.nextTag()) {
                case 2: {
                    return;
                }
                case 1: {
                    Element element = Element.of(reader.getName());
                    switch (element) {
                        case ARTIFACT: {
                            artifactVersions.add(this.parseArtifact(reader));
                            continue block7;
                        }
                    }
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
            throw ParsingUtils.unexpectedContent(reader);
        }
        throw ParsingUtils.endOfDocument(reader.getLocation());
    }

    private Artifact parseArtifact(XMLStreamReader reader) throws XMLStreamException {
        int count = reader.getAttributeCount();
        String groupId = null;
        String artifactId = null;
        String version = null;
        String classifier = null;
        String extension = null;
        EnumSet<Attribute> required = EnumSet.of(Attribute.GROUP_ID, Attribute.ARTIFACT_ID, Attribute.VERSION);
        block7: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case GROUP_ID: {
                    groupId = this.propertyReplacer.replaceProperties(reader.getAttributeValue(i));
                    continue block7;
                }
                case ARTIFACT_ID: {
                    artifactId = this.propertyReplacer.replaceProperties(reader.getAttributeValue(i));
                    continue block7;
                }
                case VERSION: {
                    version = this.propertyReplacer.replaceProperties(reader.getAttributeValue(i));
                    continue block7;
                }
                case CLASSIFIER: {
                    classifier = this.propertyReplacer.replaceProperties(reader.getAttributeValue(i));
                    continue block7;
                }
                case EXTENSION: {
                    extension = this.propertyReplacer.replaceProperties(reader.getAttributeValue(i));
                    continue block7;
                }
                default: {
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParsingUtils.missingAttributes(reader.getLocation(), required);
        }
        ParsingUtils.parseNoContent(reader);
        return new Artifact(groupId, artifactId, classifier, extension, version);
    }

    static enum Attribute {
        UNKNOWN(null),
        GROUP_ID("groupId"),
        ARTIFACT_ID("artifactId"),
        CLASSIFIER("classifier"),
        EXTENSION("extension"),
        VERSION("version"),
        NAME("name");

        private static final Map<QName, Attribute> attributes;
        private final String name;

        static Attribute of(QName qName) {
            Attribute attribute = attributes.get(qName);
            return attribute == null ? UNKNOWN : attribute;
        }

        private Attribute(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        static {
            HashMap<QName, Attribute> attributesMap = new HashMap<QName, Attribute>();
            attributesMap.put(new QName(GROUP_ID.getLocalName()), GROUP_ID);
            attributesMap.put(new QName(ARTIFACT_ID.getLocalName()), ARTIFACT_ID);
            attributesMap.put(new QName(CLASSIFIER.getLocalName()), CLASSIFIER);
            attributesMap.put(new QName(EXTENSION.getLocalName()), EXTENSION);
            attributesMap.put(new QName(VERSION.getLocalName()), VERSION);
            attributesMap.put(new QName(NAME.getLocalName()), NAME);
            attributes = attributesMap;
        }
    }

    static enum Element {
        UNKNOWN(null),
        FEATURE_PACK("feature-pack"),
        DEPENDENCIES("dependencies"),
        ARTIFACT("artifact"),
        ARTIFACT_VERSIONS("artifact-versions"),
        CONFIG("config"),
        COPY_ARTIFACTS("copy-artifacts"),
        FILTER("filter"),
        FILE_PERMISSIONS("file-permissions");

        private static final Map<QName, Element> elements;
        private final String name;

        static Element of(QName qName) {
            QName name = qName.getNamespaceURI().equals("") ? new QName(FeaturePackDescriptionXMLParser11.NAMESPACE_1_1, qName.getLocalPart()) : qName;
            Element element = elements.get(name);
            return element == null ? UNKNOWN : element;
        }

        private Element(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        static {
            HashMap<QName, Element> elementsMap = new HashMap<QName, Element>();
            elementsMap.put(new QName(FeaturePackDescriptionXMLParser11.NAMESPACE_1_1, FEATURE_PACK.getLocalName()), FEATURE_PACK);
            elementsMap.put(new QName(FeaturePackDescriptionXMLParser11.NAMESPACE_1_1, DEPENDENCIES.getLocalName()), DEPENDENCIES);
            elementsMap.put(new QName(FeaturePackDescriptionXMLParser11.NAMESPACE_1_1, ARTIFACT.getLocalName()), ARTIFACT);
            elementsMap.put(new QName(FeaturePackDescriptionXMLParser11.NAMESPACE_1_1, ARTIFACT_VERSIONS.getLocalName()), ARTIFACT_VERSIONS);
            elementsMap.put(new QName(FeaturePackDescriptionXMLParser11.NAMESPACE_1_1, CONFIG.getLocalName()), CONFIG);
            elementsMap.put(new QName(FeaturePackDescriptionXMLParser11.NAMESPACE_1_1, COPY_ARTIFACTS.getLocalName()), COPY_ARTIFACTS);
            elementsMap.put(new QName(FeaturePackDescriptionXMLParser11.NAMESPACE_1_1, FILTER.getLocalName()), FILTER);
            elementsMap.put(new QName(FeaturePackDescriptionXMLParser11.NAMESPACE_1_1, FILE_PERMISSIONS.getLocalName()), FILE_PERMISSIONS);
            elements = elementsMap;
        }
    }
}

