/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.build;

import java.io.File;
import java.util.List;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.wildfly.build.ArtifactFileResolver;
import org.wildfly.build.pack.model.Artifact;

public class AetherArtifactFileResolver
implements ArtifactFileResolver {
    private final RepositorySystem repoSystem;
    private final RepositorySystemSession repoSession;
    private final List<RemoteRepository> remoteRepos;

    public AetherArtifactFileResolver(RepositorySystem repoSystem, RepositorySystemSession repoSession, List<RemoteRepository> remoteRepos) {
        this.repoSystem = repoSystem;
        this.repoSession = repoSession;
        this.remoteRepos = remoteRepos;
    }

    @Override
    public File getArtifactFile(String artifactCoords) {
        return this.getArtifactFile(new DefaultArtifact(artifactCoords));
    }

    private File getArtifactFile(org.eclipse.aether.artifact.Artifact artifact) {
        ArtifactResult result;
        ArtifactRequest request = new ArtifactRequest();
        request.setArtifact(artifact);
        request.setRepositories(this.remoteRepos);
        try {
            result = this.repoSystem.resolveArtifact(this.repoSession, request);
        }
        catch (ArtifactResolutionException e) {
            throw new RuntimeException("failed to resolve artifact " + artifact, e);
        }
        return result.getArtifact().getFile();
    }

    @Override
    public File getArtifactFile(Artifact artifact) {
        Artifact.GACE GACE2 = artifact.getGACE();
        String groupId = GACE2.getGroupId();
        String artifactId = GACE2.getArtifactId();
        String extension = GACE2.getExtension() != null ? GACE2.getExtension() : "jar";
        String classifier = GACE2.getClassifier() != null ? GACE2.getClassifier() : "";
        return this.getArtifactFile(new DefaultArtifact(groupId, artifactId, classifier, extension, artifact.getVersion()));
    }
}

