/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.build.configassembly;

import java.io.File;
import org.wildfly.build.configassembly.ConfigurationAssembler;
import org.wildfly.build.util.BaseDirSubsystemInputStreamSources;
import org.wildfly.build.util.FileInputStreamSource;
import org.wildfly.build.util.PropertyResolver;

public class DomainMain {
    public static void main(String[] args) throws Exception {
        File baseDir = new File(args[0]);
        if (!baseDir.exists() || !baseDir.isDirectory()) {
            throw new IllegalArgumentException("Base dir does not exist: " + baseDir);
        }
        File templateFile = new File(args[1]);
        if (!templateFile.exists()) {
            throw new IllegalArgumentException("Template file does not exist: " + templateFile);
        }
        File subsystemsFile = new File(args[2]);
        if (!subsystemsFile.exists()) {
            throw new IllegalArgumentException("Subsystems file does not exist " + subsystemsFile);
        }
        File outputFile = new File(args[3]);
        BaseDirSubsystemInputStreamSources subsystemInputStreamSources = new BaseDirSubsystemInputStreamSources(baseDir.getAbsoluteFile());
        ConfigurationAssembler assembler = new ConfigurationAssembler(subsystemInputStreamSources, new FileInputStreamSource(templateFile), "domain", new FileInputStreamSource(subsystemsFile), outputFile, PropertyResolver.NO_OP);
        assembler.assemble();
    }
}

