/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.build.pack.model;

public class Artifact
implements Comparable<Artifact> {
    private final GACE GACE;
    private String version;

    public Artifact(String groupId, String artifactId, String classifier, String extension, String version) {
        this(new GACE(groupId, artifactId, classifier, extension), version);
    }

    public Artifact(GACE GACE2, String version) {
        if (GACE2 == null) {
            throw new IllegalArgumentException("null gac");
        }
        this.GACE = GACE2;
        if (version == null) {
            throw new IllegalArgumentException("null version");
        }
        this.version = version;
    }

    public GACE getGACE() {
        return this.GACE;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Artifact artifact = (Artifact)o;
        if (!this.GACE.equals(artifact.GACE)) {
            return false;
        }
        return this.version.equals(artifact.version);
    }

    public int hashCode() {
        int result = this.GACE.hashCode();
        result = 31 * result + this.version.hashCode();
        return result;
    }

    @Override
    public int compareTo(Artifact o) {
        int result = this.GACE.compareTo(o.GACE);
        if (result == 0) {
            result = this.version.compareTo(o.version);
        }
        return result;
    }

    public static class GACE
    implements Comparable<GACE> {
        private final String groupId;
        private final String artifactId;
        private final String classifier;
        private final String extension;

        public GACE(String groupId, String artifactId, String classifier, String extension) {
            if (groupId == null) {
                throw new IllegalArgumentException("null groupId");
            }
            this.groupId = groupId;
            if (artifactId == null) {
                throw new IllegalArgumentException("null artifactId");
            }
            this.artifactId = artifactId;
            this.classifier = classifier != null && !classifier.isEmpty() ? classifier : null;
            this.extension = extension != null && !extension.equals("jar") ? extension : null;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public String getClassifier() {
            return this.classifier;
        }

        public String getExtension() {
            return this.extension;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GACE GACE2 = (GACE)o;
            if (!this.groupId.equals(GACE2.groupId)) {
                return false;
            }
            if (!this.artifactId.equals(GACE2.artifactId)) {
                return false;
            }
            if (this.classifier != null ? !this.classifier.equals(GACE2.classifier) : GACE2.classifier != null) {
                return false;
            }
            return !(this.extension != null ? !this.extension.equals(GACE2.extension) : GACE2.extension != null);
        }

        public int hashCode() {
            int result = this.groupId.hashCode();
            result = 31 * result + this.artifactId.hashCode();
            result = 31 * result + (this.classifier != null ? this.classifier.hashCode() : 0);
            result = 31 * result + (this.extension != null ? this.extension.hashCode() : 0);
            return result;
        }

        @Override
        public int compareTo(GACE o) {
            int result = this.groupId.compareTo(o.groupId);
            if (result == 0 && (result = this.artifactId.compareTo(o.artifactId)) == 0) {
                if (this.classifier != null) {
                    result = o.classifier == null ? 1 : this.classifier.compareTo(o.classifier);
                } else if (o.classifier != null) {
                    result = -1;
                }
                if (result == 0) {
                    if (this.extension != null) {
                        result = o.extension == null ? 1 : this.extension.compareTo(o.extension);
                    } else if (o.extension != null) {
                        result = -1;
                    }
                }
            }
            return result;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.groupId).append(':').append(this.artifactId);
            if (this.classifier != null) {
                sb.append("::").append(this.classifier);
            }
            return sb.toString();
        }
    }
}

