/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.build.pack.model;

import java.util.HashMap;
import java.util.Map;
import org.wildfly.build.ArtifactResolver;
import org.wildfly.build.pack.model.Artifact;
import org.wildfly.build.pack.model.FeaturePackDescription;

public class FeaturePackArtifactResolver
implements ArtifactResolver {
    private final ArtifactResolver parent;
    private final Map<String, Artifact> artifactMap;

    public FeaturePackArtifactResolver(FeaturePackDescription featurePackDescription, ArtifactResolver parent) {
        this.parent = parent;
        this.artifactMap = new HashMap<String, Artifact>();
        for (Artifact artifact : featurePackDescription.getArtifactVersions()) {
            StringBuilder sb = new StringBuilder();
            sb.append(artifact.getGACE().getGroupId());
            sb.append(':');
            sb.append(artifact.getGACE().getArtifactId());
            if (artifact.getGACE().getClassifier() != null && !artifact.getGACE().getClassifier().isEmpty()) {
                this.artifactMap.put(sb.append("::").append(artifact.getGACE().getClassifier()).toString(), artifact);
                continue;
            }
            this.artifactMap.put(sb.toString(), artifact);
        }
    }

    @Override
    public Artifact getArtifact(String artifactCoords) {
        Artifact artifact = this.parent.getArtifact(artifactCoords);
        if (artifact == null) {
            artifact = this.artifactMap.get(artifactCoords);
        }
        return artifact;
    }

    @Override
    public Artifact getArtifact(Artifact.GACE GACE2) {
        StringBuilder sb = new StringBuilder();
        sb.append(GACE2.getGroupId());
        sb.append(':');
        sb.append(GACE2.getArtifactId());
        if (GACE2.getClassifier() != null) {
            sb.append("::").append(GACE2.getClassifier());
        }
        return this.getArtifact(sb.toString());
    }
}

