/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.build.pack.model;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.xml.stream.XMLStreamException;
import org.wildfly.build.ArtifactFileResolver;
import org.wildfly.build.ArtifactResolver;
import org.wildfly.build.pack.model.Artifact;
import org.wildfly.build.pack.model.FeaturePack;
import org.wildfly.build.pack.model.FeaturePackArtifactResolver;
import org.wildfly.build.pack.model.FeaturePackDescription;
import org.wildfly.build.pack.model.FeaturePackDescriptionXMLParser;
import org.wildfly.build.util.PropertyResolver;

public class FeaturePackFactory {
    private static final String CONFIGURATION_ENTRY_NAME_PREFIX = "configuration" + File.separator;
    private static final String MODULES_ENTRY_NAME_PREFIX = "modules" + File.separator;
    private static final String CONTENT_ENTRY_NAME_PREFIX = "content" + File.separator;

    public static FeaturePack createPack(String artifactCoords, ArtifactResolver artifactResolver, ArtifactFileResolver artifactFileResolver) {
        return FeaturePackFactory.createPack(artifactCoords, artifactResolver, artifactFileResolver, new HashSet<String>());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static FeaturePack createPack(String artifactCoords, ArtifactResolver artifactResolver, ArtifactFileResolver artifactFileResolver, Set<String> processedFeaturePacks) {
        if (!processedFeaturePacks.add(artifactCoords)) {
            throw new IllegalStateException("Cyclic dependency, feature pack " + artifactCoords + " already processed! Feature packs: " + processedFeaturePacks);
        }
        Artifact artifact = artifactResolver.getArtifact(artifactCoords);
        if (artifact == null) {
            throw new RuntimeException("Could not resolve artifact for feature package " + artifactCoords);
        }
        File artifactFile = artifactFileResolver.getArtifactFile(artifact);
        if (artifactFile == null) {
            throw new RuntimeException("Could not resolve artifact file for feature package  " + artifactCoords);
        }
        try (JarFile jar = new JarFile(artifactFile);){
            ArrayList<String> configurationFiles = new ArrayList<String>();
            ArrayList<String> modulesFiles = new ArrayList<String>();
            ArrayList<String> contentFiles = new ArrayList<String>();
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String entryName = entry.getName();
                if (entryName.startsWith(CONFIGURATION_ENTRY_NAME_PREFIX)) {
                    configurationFiles.add(entryName);
                    continue;
                }
                if (entryName.startsWith(MODULES_ENTRY_NAME_PREFIX)) {
                    modulesFiles.add(entryName);
                    continue;
                }
                if (!entryName.startsWith(CONTENT_ENTRY_NAME_PREFIX)) continue;
                contentFiles.add(entryName);
            }
            FeaturePackDescription description = FeaturePackFactory.createFeaturePackDescription(jar);
            FeaturePackArtifactResolver featurePackArtifactResolver = new FeaturePackArtifactResolver(description, artifactResolver);
            ArrayList<FeaturePack> dependencies = new ArrayList<FeaturePack>();
            for (String dependency : description.getDependencies()) {
                dependencies.add(FeaturePackFactory.createPack(dependency, featurePackArtifactResolver, artifactFileResolver, new HashSet<String>(processedFeaturePacks)));
            }
            FeaturePack featurePack = new FeaturePack(artifactFile, artifact, description, dependencies, featurePackArtifactResolver, configurationFiles, modulesFiles, contentFiles);
            return featurePack;
        }
        catch (Throwable e) {
            throw new RuntimeException("Failed to create feature pack from " + artifactCoords, e);
        }
    }

    private static FeaturePackDescription createFeaturePackDescription(JarFile jar) throws IOException, XMLStreamException {
        ZipEntry zipEntry = jar.getEntry("wildfly-feature-pack.xml");
        if (zipEntry == null) {
            throw new IllegalArgumentException("feature pack description not found");
        }
        FeaturePackDescriptionXMLParser parser = new FeaturePackDescriptionXMLParser(PropertyResolver.NO_OP);
        try (InputStream inputStream = jar.getInputStream(zipEntry);){
            FeaturePackDescription featurePackDescription = parser.parse(inputStream);
            return featurePackDescription;
        }
    }
}

