/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.build.pack.model;

import java.nio.file.attribute.PosixFilePermission;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.wildfly.build.pack.model.FileFilter;

public class FilePermission {
    private final Set<PosixFilePermission> permission;
    private final String value;
    private final List<FileFilter> filters = new ArrayList<FileFilter>();

    public FilePermission(String value) {
        this.value = value;
        this.permission = FilePermission.fromString(value);
    }

    private static Set<PosixFilePermission> fromString(String permission) {
        int others;
        int group;
        if (permission.length() != 3) {
            throw new RuntimeException("Permission string must be 3 digits");
        }
        HashSet<PosixFilePermission> permissions = new HashSet<PosixFilePermission>();
        int user = Integer.parseInt(Character.toString(permission.charAt(0)));
        if ((user & 1) != 0) {
            permissions.add(PosixFilePermission.OWNER_EXECUTE);
        }
        if ((user & 2) != 0) {
            permissions.add(PosixFilePermission.OWNER_WRITE);
        }
        if ((user & 4) != 0) {
            permissions.add(PosixFilePermission.OWNER_READ);
        }
        if (((group = Integer.parseInt(Character.toString(permission.charAt(1)))) & 1) != 0) {
            permissions.add(PosixFilePermission.GROUP_EXECUTE);
        }
        if ((group & 2) != 0) {
            permissions.add(PosixFilePermission.GROUP_WRITE);
        }
        if ((group & 4) != 0) {
            permissions.add(PosixFilePermission.GROUP_READ);
        }
        if (((others = Integer.parseInt(Character.toString(permission.charAt(2)))) & 1) != 0) {
            permissions.add(PosixFilePermission.OTHERS_EXECUTE);
        }
        if ((others & 2) != 0) {
            permissions.add(PosixFilePermission.OTHERS_WRITE);
        }
        if ((others & 4) != 0) {
            permissions.add(PosixFilePermission.OTHERS_READ);
        }
        return permissions;
    }

    public Set<PosixFilePermission> getPermission() {
        return this.permission;
    }

    public List<FileFilter> getFilters() {
        return this.filters;
    }

    public String getValue() {
        return this.value;
    }

    public boolean includeFile(String path) {
        for (FileFilter filter : this.filters) {
            if (!filter.matches(path)) continue;
            return filter.isInclude();
        }
        return false;
    }
}

