/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.build.configassembly;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.wildfly.build.configassembly.SubsystemConfig;
import org.wildfly.build.util.BuildPropertyReplacer;
import org.wildfly.build.util.InputStreamSource;
import org.wildfly.build.util.PropertyResolver;

class SubsystemsParser {
    static String NAMESPACE = "urn:subsystems-config:1.0";
    private final InputStreamSource inputStreamSource;
    private final BuildPropertyReplacer propertyReplacer;
    Map<String, SubsystemConfig[]> subsystemConfigs = new HashMap<String, SubsystemConfig[]>();

    SubsystemsParser(InputStreamSource inputStreamSource, BuildPropertyReplacer propertyReplacer) {
        this.inputStreamSource = inputStreamSource;
        this.propertyReplacer = propertyReplacer;
    }

    SubsystemsParser(InputStreamSource inputStreamSource) {
        this(inputStreamSource, new BuildPropertyReplacer(PropertyResolver.NO_OP));
    }

    Map<String, SubsystemConfig[]> getSubsystemConfigs() {
        return this.subsystemConfigs;
    }

    void parse() throws IOException, XMLStreamException {
        try (InputStream in = this.inputStreamSource.getInputStream();){
            XMLStreamReader reader = XMLInputFactory.newInstance().createXMLStreamReader(in);
            reader.require(7, null, null);
            boolean done = false;
            while (reader.hasNext()) {
                int type = reader.next();
                switch (type) {
                    case 1: {
                        if (!done && reader.getLocalName().equals("config")) {
                            this.parseSubsystems(reader);
                            done = true;
                            break;
                        }
                        throw new XMLStreamException("Invalid element " + reader.getLocalName(), reader.getLocation());
                    }
                    case 8: {
                        return;
                    }
                }
            }
        }
    }

    private void parseSubsystems(XMLStreamReader reader) throws XMLStreamException {
        while (reader.hasNext()) {
            int type = reader.next();
            switch (type) {
                case 1: {
                    if (reader.getLocalName().equals("subsystems")) {
                        String name = "";
                        for (int i = 0; i < reader.getAttributeCount(); ++i) {
                            if (!reader.getAttributeLocalName(i).equals("name")) {
                                throw new XMLStreamException("Unknown attribute " + reader.getAttributeLocalName(i), reader.getLocation());
                            }
                            name = this.propertyReplacer.replaceProperties(reader.getAttributeValue(i));
                        }
                        if (this.subsystemConfigs.containsKey(name)) {
                            throw new XMLStreamException("Already have a subsystems named " + name, reader.getLocation());
                        }
                        ArrayList<SubsystemConfig> subsystems = new ArrayList<SubsystemConfig>();
                        this.parseSubsystem(reader, subsystems);
                        this.subsystemConfigs.put(name, subsystems.toArray(new SubsystemConfig[subsystems.size()]));
                        break;
                    }
                    throw new XMLStreamException("Invalid element " + reader.getLocalName(), reader.getLocation());
                }
                case 2: {
                    if (!reader.getLocalName().equals("config")) break;
                    return;
                }
            }
        }
    }

    private void parseSubsystem(XMLStreamReader reader, List<SubsystemConfig> subsystems) throws XMLStreamException {
        reader.next();
        block4: while (true) {
            switch (reader.getEventType()) {
                case 1: {
                    if (reader.getLocalName().equals("subsystem")) {
                        String supplement = null;
                        String systemProperty = null;
                        for (int i = 0; i < reader.getAttributeCount(); ++i) {
                            String attr = reader.getAttributeLocalName(i);
                            if (attr.equals("supplement")) {
                                supplement = this.propertyReplacer.replaceProperties(reader.getAttributeValue(i));
                                continue;
                            }
                            if (attr.equals("include-if-set")) {
                                systemProperty = reader.getAttributeValue(i);
                                continue;
                            }
                            throw new XMLStreamException("Unknown attribute " + attr, reader.getLocation());
                        }
                        if (supplement != null && supplement.isEmpty()) {
                            supplement = null;
                        }
                        String text = reader.getElementText();
                        if (systemProperty != null) {
                            if (System.getProperty(systemProperty) == null) continue block4;
                            subsystems.add(new SubsystemConfig(text, supplement));
                            continue block4;
                        }
                        subsystems.add(new SubsystemConfig(text, supplement));
                        continue block4;
                    }
                    throw new XMLStreamException("Invalid element " + reader.getLocalName(), reader.getLocation());
                }
                case 2: {
                    if (!reader.getLocalName().equals("subsystems")) break;
                    return;
                }
            }
            reader.next();
        }
    }
}

