/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.build.pack.model;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.wildfly.build.ArtifactResolver;
import org.wildfly.build.pack.model.Artifact;
import org.wildfly.build.pack.model.FeaturePackDescription;
import org.wildfly.build.pack.model.ModuleIdentifier;
import org.wildfly.build.util.ModuleParseResult;
import org.wildfly.build.util.ModuleParser;

public class FeaturePack {
    private final File featurePackFile;
    private final Artifact featurePackArtifact;
    private final FeaturePackDescription description;
    private final List<String> configurationFiles;
    private final List<String> modulesFiles;
    private final List<String> contentFiles;
    private final List<FeaturePack> dependencies;
    private final ArtifactResolver artifactResolver;
    private Map<ModuleIdentifier, ModuleParseResult> modules;
    private static final String MODULE_XML_ENTRY_NAME_SUFIX = "/module.xml";

    public FeaturePack(File featurePackFile, Artifact featurePackArtifact, FeaturePackDescription description, List<FeaturePack> dependencies, ArtifactResolver artifactResolver, List<String> configurationFiles, List<String> modulesFiles, List<String> contentFiles) {
        this.featurePackFile = featurePackFile;
        this.featurePackArtifact = featurePackArtifact;
        this.description = description;
        this.dependencies = dependencies;
        this.artifactResolver = artifactResolver;
        this.configurationFiles = Collections.unmodifiableList(configurationFiles);
        this.modulesFiles = Collections.unmodifiableList(modulesFiles);
        this.contentFiles = Collections.unmodifiableList(contentFiles);
    }

    public FeaturePackDescription getDescription() {
        return this.description;
    }

    public File getFeaturePackFile() {
        return this.featurePackFile;
    }

    public Artifact getArtifact() {
        return this.featurePackArtifact;
    }

    public List<FeaturePack> getDependencies() {
        return this.dependencies;
    }

    public ArtifactResolver getArtifactResolver() {
        return this.artifactResolver;
    }

    public List<String> getConfigurationFiles() {
        return this.configurationFiles;
    }

    public List<String> getModulesFiles() {
        return this.modulesFiles;
    }

    public List<String> getContentFiles() {
        return this.contentFiles;
    }

    public synchronized Map<ModuleIdentifier, ModuleParseResult> getModules() {
        if (this.modules == null) {
            this.modules = new HashMap<ModuleIdentifier, ModuleParseResult>();
            try (JarFile jar = new JarFile(this.featurePackFile);){
                for (String moduleFile : this.modulesFiles) {
                    if (!moduleFile.endsWith(MODULE_XML_ENTRY_NAME_SUFIX)) continue;
                    ZipEntry entry = jar.getEntry(moduleFile);
                    ModuleParseResult moduleParseResult = ModuleParser.parse(jar.getInputStream(entry));
                    this.modules.put(moduleParseResult.getIdentifier(), moduleParseResult);
                }
            }
            catch (Throwable e) {
                throw new RuntimeException("Failed to parse feature pack modules from " + this.featurePackFile, e);
            }
            this.modules = Collections.unmodifiableMap(this.modules);
        }
        return this.modules;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeaturePack that = (FeaturePack)o;
        return this.featurePackFile.equals(that.featurePackFile);
    }

    public int hashCode() {
        return this.featurePackFile.hashCode();
    }
}

