/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.build.util;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import org.wildfly.build.configassembly.SubsystemInputStreamSources;
import org.wildfly.build.util.InputStreamSource;
import org.wildfly.build.util.ZipEntryInputStreamSource;

public class ZipFileSubsystemInputStreamSources
implements SubsystemInputStreamSources {
    private final Map<String, ZipEntryInputStreamSource> inputStreamSourceMap = new HashMap<String, ZipEntryInputStreamSource>();

    public void addSubsystemFileSource(String subsystemFileName, File zipFile, ZipEntry zipEntry) {
        this.inputStreamSourceMap.put(subsystemFileName, new ZipEntryInputStreamSource(zipFile, zipEntry));
    }

    public void addAllSubsystemFileSources(ZipFileSubsystemInputStreamSources other) {
        for (Map.Entry<String, ZipEntryInputStreamSource> entry : other.inputStreamSourceMap.entrySet()) {
            if (this.inputStreamSourceMap.containsKey(entry.getKey())) continue;
            this.inputStreamSourceMap.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public InputStreamSource getInputStreamSource(String subsystemFileName) {
        return this.inputStreamSourceMap.get(subsystemFileName);
    }

    public String toString() {
        return "zip subsystem parser factory files: " + this.inputStreamSourceMap.keySet();
    }
}

