/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.build.pack.model;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.xml.stream.XMLStreamException;
import org.wildfly.build.ArtifactFileResolver;
import org.wildfly.build.ArtifactResolver;
import org.wildfly.build.pack.model.Artifact;
import org.wildfly.build.pack.model.DelegatingArtifactResolver;
import org.wildfly.build.pack.model.FeaturePack;
import org.wildfly.build.pack.model.FeaturePackArtifactResolver;
import org.wildfly.build.pack.model.FeaturePackDescription;
import org.wildfly.build.pack.model.FeaturePackDescriptionXMLParser;
import org.wildfly.build.util.PropertyResolver;

public class FeaturePackFactory {
    private static final String CONFIGURATION_ENTRY_NAME_PREFIX = "configuration/";
    private static final String MODULES_ENTRY_NAME_PREFIX = "modules/";
    private static final String CONTENT_ENTRY_NAME_PREFIX = "content/";

    public static FeaturePack createPack(Artifact artifactCoords, ArtifactFileResolver artifactFileResolver, ArtifactResolver versionOverrideResolver) {
        return FeaturePackFactory.createPack(artifactCoords, artifactFileResolver, versionOverrideResolver, new HashSet<Artifact>());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static FeaturePack createPack(Artifact artifactCoords, ArtifactFileResolver artifactFileResolver, ArtifactResolver versionOverrideResolver, Set<Artifact> processedFeaturePacks) {
        if (!processedFeaturePacks.add(artifactCoords)) {
            throw new IllegalStateException("Cyclic dependency, feature pack " + artifactCoords + " already processed! Feature packs: " + processedFeaturePacks);
        }
        File artifactFile = artifactFileResolver.getArtifactFile(artifactCoords);
        if (artifactFile == null) {
            throw new RuntimeException("Could not resolve artifact file for feature package  " + artifactCoords);
        }
        try (JarFile jar = new JarFile(artifactFile);){
            ArrayList<String> configurationFiles = new ArrayList<String>();
            ArrayList<String> modulesFiles = new ArrayList<String>();
            ArrayList<String> contentFiles = new ArrayList<String>();
            Enumeration<JarEntry> entries = jar.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String entryName = entry.getName();
                if (entryName.startsWith(CONFIGURATION_ENTRY_NAME_PREFIX)) {
                    configurationFiles.add(entryName);
                    continue;
                }
                if (entryName.startsWith(MODULES_ENTRY_NAME_PREFIX)) {
                    modulesFiles.add(entryName);
                    continue;
                }
                if (!entryName.startsWith(CONTENT_ENTRY_NAME_PREFIX)) continue;
                contentFiles.add(entryName);
            }
            FeaturePackDescription description = FeaturePackFactory.createFeaturePackDescription(jar);
            FeaturePackArtifactResolver featurePackArtifactResolver = new FeaturePackArtifactResolver(description.getArtifactVersions());
            DelegatingArtifactResolver delegatingArtifactResolver = new DelegatingArtifactResolver(versionOverrideResolver, featurePackArtifactResolver);
            ArrayList<FeaturePack> dependencies = new ArrayList<FeaturePack>();
            for (String dependency : description.getDependencies()) {
                dependencies.add(FeaturePackFactory.createPack(delegatingArtifactResolver.getArtifact(dependency), artifactFileResolver, versionOverrideResolver, new HashSet<Artifact>(processedFeaturePacks)));
            }
            FeaturePack featurePack = new FeaturePack(artifactFile, artifactCoords, description, dependencies, delegatingArtifactResolver, configurationFiles, modulesFiles, contentFiles);
            return featurePack;
        }
        catch (Throwable e) {
            throw new RuntimeException("Failed to create feature pack from " + artifactCoords, e);
        }
    }

    private static FeaturePackDescription createFeaturePackDescription(JarFile jar) throws IOException, XMLStreamException {
        ZipEntry zipEntry = jar.getEntry("wildfly-feature-pack.xml");
        if (zipEntry == null) {
            throw new IllegalArgumentException("feature pack description not found");
        }
        FeaturePackDescriptionXMLParser parser = new FeaturePackDescriptionXMLParser(PropertyResolver.NO_OP);
        try (InputStream inputStream = jar.getInputStream(zipEntry);){
            FeaturePackDescription featurePackDescription = parser.parse(inputStream);
            return featurePackDescription;
        }
    }
}

