/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.build.provisioning;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.xml.stream.XMLStreamException;
import org.jboss.logging.Logger;
import org.wildfly.build.ArtifactFileResolver;
import org.wildfly.build.ArtifactResolver;
import org.wildfly.build.configassembly.ConfigurationAssembler;
import org.wildfly.build.configassembly.SubsystemInputStreamSources;
import org.wildfly.build.pack.model.Artifact;
import org.wildfly.build.pack.model.Config;
import org.wildfly.build.pack.model.ConfigFile;
import org.wildfly.build.pack.model.CopyArtifact;
import org.wildfly.build.pack.model.FeaturePack;
import org.wildfly.build.pack.model.FeaturePackFactory;
import org.wildfly.build.pack.model.FilePermission;
import org.wildfly.build.provisioning.model.ServerProvisioning;
import org.wildfly.build.provisioning.model.ServerProvisioningDescription;
import org.wildfly.build.util.FileUtils;
import org.wildfly.build.util.MapPropertyResolver;
import org.wildfly.build.util.ZipEntryInputStreamSource;

public class ServerProvisioner {
    private static final Logger logger = Logger.getLogger(ServerProvisioner.class);
    private static final String SUBSYSTEM_TEMPLATES_ENTRY_PREFIX = "subsystem-templates/";
    private static final String SUBSYSTEM_SCHEMA_ENTRY_PREFIX = "schema/";
    private static final String SUBSYSTEM_SCHEMA_TARGET_DIRECTORY = "docs" + File.separator + "schema";
    private static final boolean OS_WINDOWS = System.getProperty("os.name").contains("indows");

    public static void build(ServerProvisioningDescription description, File outputDirectory, ArtifactFileResolver artifactFileResolver, ArtifactResolver versionOverrideArtifactResolver) {
        ServerProvisioning serverProvisioning = new ServerProvisioning(description);
        ArrayList errors = new ArrayList();
        try {
            File schemaOutputDirectory;
            for (Artifact featurePackArtifactCoords : description.getFeaturePacks()) {
                FeaturePack featurePack = FeaturePackFactory.createPack(featurePackArtifactCoords, artifactFileResolver, versionOverrideArtifactResolver);
                serverProvisioning.getFeaturePacks().add(featurePack);
            }
            FileUtils.deleteRecursive(outputDirectory);
            outputDirectory.mkdirs();
            if (serverProvisioning.getDescription().isExtractSchemas()) {
                schemaOutputDirectory = new File(outputDirectory, SUBSYSTEM_SCHEMA_TARGET_DIRECTORY);
                if (!schemaOutputDirectory.exists()) {
                    schemaOutputDirectory.mkdirs();
                }
            } else {
                schemaOutputDirectory = null;
            }
            HashSet<String> filesProcessed = new HashSet<String>();
            for (FeaturePack featurePack : serverProvisioning.getFeaturePacks()) {
                ServerProvisioner.processFeaturePackModules(featurePack, serverProvisioning, outputDirectory, filesProcessed, artifactFileResolver, schemaOutputDirectory);
            }
            for (FeaturePack featurePack : serverProvisioning.getFeaturePacks()) {
                ServerProvisioner.processConfig(featurePack, serverProvisioning, outputDirectory, filesProcessed);
                ServerProvisioner.processCopyArtifacts(featurePack, outputDirectory, filesProcessed, artifactFileResolver, schemaOutputDirectory);
                ServerProvisioner.extractFeaturePackContents(featurePack, outputDirectory, filesProcessed);
                ServerProvisioner.processFilePermissions(featurePack, outputDirectory);
            }
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        finally {
            if (!errors.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("Some errors were encountered creating the feature pack\n");
                for (String error : errors) {
                    sb.append(error);
                    sb.append("\n");
                }
                throw new RuntimeException(sb.toString());
            }
        }
    }

    /*
     * Exception decompiling
     */
    private static void processFeaturePackModules(FeaturePack featurePack, ServerProvisioning serverProvisioning, File outputDirectory, Set<String> filesProcessed, ArtifactFileResolver artifactFileResolver, File schemaOutputDirectory) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void processConfig(FeaturePack featurePack, ServerProvisioning serverProvisioning, File outputDirectory, Set<String> filesProcessed) throws IOException, XMLStreamException {
        SubsystemInputStreamSources subsystemInputStreamSources = serverProvisioning.getSubsystemInputStreamSourcesMap().get(featurePack);
        Config config = featurePack.getDescription().getConfig();
        try (ZipFile zipFile = new ZipFile(featurePack.getFeaturePackFile());){
            for (ConfigFile configFile : config.getDomainConfigFiles()) {
                ServerProvisioner.processConfigFile(configFile, featurePack, zipFile, subsystemInputStreamSources, "domain", outputDirectory, filesProcessed);
            }
            for (ConfigFile configFile : config.getStandaloneConfigFiles()) {
                ServerProvisioner.processConfigFile(configFile, featurePack, zipFile, subsystemInputStreamSources, "server", outputDirectory, filesProcessed);
            }
        }
        for (FeaturePack dependency : featurePack.getDependencies()) {
            ServerProvisioner.processConfig(dependency, serverProvisioning, outputDirectory, filesProcessed);
        }
    }

    private static void processConfigFile(ConfigFile configFile, FeaturePack featurePack, ZipFile zipFile, SubsystemInputStreamSources subsystemInputStreamSources, String templateRootElementName, File outputDirectory, Set<String> filesProcessed) throws IOException, XMLStreamException {
        if (!filesProcessed.add(configFile.getOutputFile())) {
            return;
        }
        ZipEntry templateFileZipEntry = zipFile.getEntry(configFile.getTemplate());
        if (templateFileZipEntry == null) {
            throw new RuntimeException("Feature pack " + featurePack.getFeaturePackFile() + " template file " + configFile.getTemplate() + " not found");
        }
        ZipEntry subsystemsFileZipEntry = zipFile.getEntry(configFile.getSubsystems());
        if (subsystemsFileZipEntry == null) {
            throw new RuntimeException("Feature pack " + featurePack.getFeaturePackFile() + " subsystems file " + configFile.getSubsystems() + " not found");
        }
        new ConfigurationAssembler(subsystemInputStreamSources, new ZipEntryInputStreamSource(featurePack.getFeaturePackFile(), templateFileZipEntry), templateRootElementName, new ZipEntryInputStreamSource(featurePack.getFeaturePackFile(), subsystemsFileZipEntry), new File(outputDirectory, configFile.getOutputFile()), new MapPropertyResolver(configFile.getProperties())).assemble();
    }

    private static void processCopyArtifacts(FeaturePack featurePack, File outputDirectory, Set<String> filesProcessed, ArtifactFileResolver artifactFileResolver, File schemaOutputDirectory) throws IOException {
        for (CopyArtifact copyArtifact : featurePack.getDescription().getCopyArtifacts()) {
            if (!filesProcessed.add(copyArtifact.getToLocation())) continue;
            File target = new File(outputDirectory, copyArtifact.getToLocation());
            if (!target.getParentFile().isDirectory() && !target.getParentFile().mkdirs()) {
                throw new IOException("Could not create directory " + target.getParentFile());
            }
            Artifact artifact = featurePack.getArtifactResolver().getArtifact(copyArtifact.getArtifact());
            if (artifact == null) {
                throw new RuntimeException("Could not resolve artifact " + copyArtifact.getArtifact() + " to copy");
            }
            File artifactFile = artifactFileResolver.getArtifactFile(artifact);
            if (artifactFile == null) {
                throw new RuntimeException("Could not resolve file for artifact " + copyArtifact.getArtifact() + " to copy");
            }
            if (copyArtifact.isExtract()) {
                ServerProvisioner.extractArtifact(artifactFile, target, copyArtifact);
            } else {
                FileUtils.copyFile(artifactFile, target);
            }
            if (schemaOutputDirectory == null) continue;
            ZipFile zip = new ZipFile(artifactFile);
            Throwable throwable = null;
            try {
                if (zip.getEntry("schema") == null) continue;
                Enumeration<? extends ZipEntry> entries = zip.entries();
                while (entries.hasMoreElements()) {
                    String entryName;
                    ZipEntry entry = entries.nextElement();
                    if (entry.isDirectory() || !(entryName = entry.getName()).startsWith(SUBSYSTEM_SCHEMA_ENTRY_PREFIX)) continue;
                    InputStream in = zip.getInputStream(entry);
                    Throwable throwable2 = null;
                    try {
                        FileUtils.copyFile(in, new File(schemaOutputDirectory, entryName.substring(SUBSYSTEM_SCHEMA_ENTRY_PREFIX.length())));
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (in == null) continue;
                        if (throwable2 != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable x2) {
                                throwable2.addSuppressed(x2);
                            }
                            continue;
                        }
                        in.close();
                    }
                }
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (zip == null) continue;
                if (throwable != null) {
                    try {
                        zip.close();
                    }
                    catch (Throwable x2) {
                        throwable.addSuppressed(x2);
                    }
                    continue;
                }
                zip.close();
            }
        }
        for (FeaturePack dependency : featurePack.getDependencies()) {
            ServerProvisioner.processCopyArtifacts(dependency, outputDirectory, filesProcessed, artifactFileResolver, schemaOutputDirectory);
        }
    }

    private static void extractArtifact(File file, File target, CopyArtifact copy) throws IOException {
        try (ZipFile zip = new ZipFile(file);){
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (!copy.includeFile(entry.getName())) continue;
                if (entry.isDirectory()) {
                    new File(target, entry.getName()).mkdirs();
                    continue;
                }
                InputStream in = zip.getInputStream(entry);
                Throwable throwable = null;
                try {
                    FileUtils.copyFile(in, new File(target, entry.getName()));
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable x2) {
                            throwable.addSuppressed(x2);
                        }
                        continue;
                    }
                    in.close();
                }
            }
        }
    }

    private static void extractFeaturePackContents(FeaturePack featurePack, File outputDirectory, Set<String> filesProcessed) throws IOException {
        int fileNameWithoutContentsStart = "content".length() + 1;
        try (JarFile jar = new JarFile(featurePack.getFeaturePackFile());){
            for (String contentFile : featurePack.getContentFiles()) {
                String outputFile = contentFile.substring(fileNameWithoutContentsStart);
                if (!filesProcessed.add(outputFile)) continue;
                FileUtils.extractFile(jar, contentFile, new File(outputDirectory, outputFile));
            }
        }
        for (FeaturePack dependency : featurePack.getDependencies()) {
            ServerProvisioner.extractFeaturePackContents(dependency, outputDirectory, filesProcessed);
        }
    }

    private static void processFilePermissions(FeaturePack featurePack, File outputDirectory) throws IOException {
        final Path baseDir = Paths.get(outputDirectory.getAbsolutePath(), new String[0]);
        final List<FilePermission> filePermissions = featurePack.getDescription().getFilePermissions();
        Files.walkFileTree(baseDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                String relative = baseDir.relativize(dir).toString();
                if (!OS_WINDOWS) {
                    for (FilePermission perm : filePermissions) {
                        if (!perm.includeFile(relative)) continue;
                        Files.setPosixFilePermissions(dir, perm.getPermission());
                    }
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                String relative = baseDir.relativize(file).toString();
                if (!OS_WINDOWS) {
                    for (FilePermission perm : filePermissions) {
                        if (!perm.includeFile(relative)) continue;
                        Files.setPosixFilePermissions(file, perm.getPermission());
                    }
                }
                return FileVisitResult.CONTINUE;
            }
        });
        for (FeaturePack dependency : featurePack.getDependencies()) {
            ServerProvisioner.processFilePermissions(dependency, outputDirectory);
        }
    }

    static Logger getLog() {
        return logger;
    }
}

