/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.build.common.model;

import java.util.ArrayList;
import java.util.List;
import org.wildfly.build.common.model.FileFilter;

public class CopyArtifact {
    private final String artifact;
    private final String toLocation;
    private final boolean extract;
    private final List<FileFilter> filters = new ArrayList<FileFilter>();

    public CopyArtifact(String artifact, String toLocation, boolean extract) {
        this.artifact = artifact;
        this.toLocation = toLocation;
        this.extract = extract;
    }

    public String getArtifact() {
        return this.artifact;
    }

    public String getToLocation() {
        return this.toLocation;
    }

    public boolean isExtract() {
        return this.extract;
    }

    public List<FileFilter> getFilters() {
        return this.filters;
    }

    public boolean includeFile(String path) {
        for (FileFilter filter : this.filters) {
            if (!filter.matches(path)) continue;
            return filter.isInclude();
        }
        return true;
    }
}

