/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.build.provisioning.model;

import java.util.ArrayList;
import java.util.List;
import org.wildfly.build.common.model.ConfigOverride;
import org.wildfly.build.common.model.CopyArtifact;
import org.wildfly.build.common.model.FileFilter;
import org.wildfly.build.pack.model.Artifact;
import org.wildfly.build.provisioning.model.ModuleFilter;

public class ServerProvisioningDescription {
    private final List<FeaturePack> featurePacks = new ArrayList<FeaturePack>();
    private final List<Artifact> versionOverrides = new ArrayList<Artifact>();
    private final List<CopyArtifact> copyArtifacts = new ArrayList<CopyArtifact>();
    private boolean copyModuleArtifacts;
    private boolean extractSchemas;

    public List<FeaturePack> getFeaturePacks() {
        return this.featurePacks;
    }

    public boolean isCopyModuleArtifacts() {
        return this.copyModuleArtifacts;
    }

    public void setCopyModuleArtifacts(boolean copyModuleArtifacts) {
        this.copyModuleArtifacts = copyModuleArtifacts;
    }

    public boolean isExtractSchemas() {
        return this.extractSchemas;
    }

    public void setExtractSchemas(boolean extractSchemas) {
        this.extractSchemas = extractSchemas;
    }

    public List<Artifact> getVersionOverrides() {
        return this.versionOverrides;
    }

    public List<CopyArtifact> getCopyArtifacts() {
        return this.copyArtifacts;
    }

    public static class FeaturePack {
        private final Artifact artifact;
        private final ModuleFilters moduleFilters;
        private final ConfigOverride configOverride;
        private final ContentFilters contentFilters;
        private final List<Subsystem> subsystems;

        FeaturePack(Artifact artifact, ModuleFilters moduleFilters, ConfigOverride configOverride, ContentFilters contentFilters, List<Subsystem> subsystems) {
            this.artifact = artifact;
            this.moduleFilters = moduleFilters;
            this.configOverride = configOverride;
            this.contentFilters = contentFilters;
            this.subsystems = subsystems;
        }

        public Artifact getArtifact() {
            return this.artifact;
        }

        public ModuleFilters getModuleFilters() {
            return this.moduleFilters;
        }

        public ConfigOverride getConfigOverride() {
            return this.configOverride;
        }

        public ContentFilters getContentFilters() {
            return this.contentFilters;
        }

        public List<Subsystem> getSubsystems() {
            return this.subsystems;
        }

        public boolean includesContentFiles() {
            return this.configOverride == null && this.subsystems == null && this.moduleFilters == null || this.contentFilters != null;
        }

        public static class Subsystem {
            private final String module;
            private final boolean transitive;

            public Subsystem(String module, boolean transitive) {
                this.module = module;
                this.transitive = transitive;
            }

            public String getName() {
                return this.module;
            }

            public boolean isTransitive() {
                return this.transitive;
            }
        }

        public static class ContentFilters {
            private final List<FileFilter> filters = new ArrayList<FileFilter>();
            private final boolean include;

            ContentFilters(boolean include) {
                this.include = include;
            }

            public List<FileFilter> getFilters() {
                return this.filters;
            }

            public boolean isInclude() {
                return this.include;
            }
        }

        public static class ModuleFilters {
            private final List<ModuleFilter> filters = new ArrayList<ModuleFilter>();
            private final boolean include;

            ModuleFilters(boolean include) {
                this.include = include;
            }

            public List<ModuleFilter> getFilters() {
                return this.filters;
            }

            public boolean isInclude() {
                return this.include;
            }
        }
    }
}

