/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.build.provisioning.model;

import java.util.regex.Pattern;
import org.wildfly.build.util.xml.ParsingUtils;

public class ModuleFilter {
    private final String patternString;
    private final Pattern pattern;
    private final boolean include;
    private final boolean transitive;

    public ModuleFilter(String pattern, boolean include, boolean transitive) {
        if (pattern == null) {
            throw new IllegalArgumentException("null pattern");
        }
        this.patternString = pattern;
        this.pattern = Pattern.compile(ParsingUtils.wildcardToJavaRegexp(pattern));
        this.include = include;
        this.transitive = transitive;
    }

    public boolean matches(String filePath) {
        return this.pattern.matcher(filePath).matches();
    }

    public boolean isInclude() {
        return this.include;
    }

    public boolean isTransitive() {
        return this.transitive;
    }

    public String getPattern() {
        return this.patternString;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModuleFilter that = (ModuleFilter)o;
        return this.patternString.equals(that.patternString);
    }

    public int hashCode() {
        return this.patternString.hashCode();
    }

    public String toString() {
        return this.patternString;
    }
}

