/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.build.util;

import java.util.ArrayList;
import java.util.List;
import org.wildfly.build.pack.model.ModuleIdentifier;

public class ModuleParseResult {
    final List<ModuleDependency> dependencies = new ArrayList<ModuleDependency>();
    final List<String> resourceRoots = new ArrayList<String>();
    final List<ArtifactName> artifacts = new ArrayList<ArtifactName>();
    ModuleIdentifier identifier;

    public List<ModuleDependency> getDependencies() {
        return this.dependencies;
    }

    public List<String> getResourceRoots() {
        return this.resourceRoots;
    }

    public List<ArtifactName> getArtifacts() {
        return this.artifacts;
    }

    public ModuleIdentifier getIdentifier() {
        return this.identifier;
    }

    public static class ArtifactName {
        private final String artifactCoords;
        private final String options;

        public ArtifactName(String artifactCoords, String options) {
            this.artifactCoords = artifactCoords;
            this.options = options;
        }

        public String getArtifactCoords() {
            return this.artifactCoords;
        }

        public String getOptions() {
            return this.options;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.artifactCoords);
            if (this.options != null) {
                sb.append('?').append(this.options);
            }
            return sb.toString();
        }
    }

    public static class ModuleDependency {
        private final ModuleIdentifier moduleId;
        private final boolean optional;

        public ModuleDependency(ModuleIdentifier moduleId, boolean optional) {
            this.moduleId = moduleId;
            this.optional = optional;
        }

        public ModuleIdentifier getModuleId() {
            return this.moduleId;
        }

        public boolean isOptional() {
            return this.optional;
        }

        public String toString() {
            return "[" + this.moduleId + (this.optional ? ",optional=true" : "") + "]";
        }
    }
}

