/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.build.common.model;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.wildfly.build.common.model.FileFilter;
import org.wildfly.build.util.BuildPropertyReplacer;
import org.wildfly.build.util.xml.ParsingUtils;

public class FileFilterModelParser10 {
    public static final String ELEMENT_LOCAL_NAME = "filter";
    private final BuildPropertyReplacer propertyReplacer;

    public FileFilterModelParser10(BuildPropertyReplacer propertyReplacer) {
        this.propertyReplacer = propertyReplacer;
    }

    public void parseFilter(XMLStreamReader reader, List<FileFilter> filters) throws XMLStreamException {
        String pattern = null;
        boolean include = false;
        EnumSet<Attribute> required = EnumSet.of(Attribute.PATTERN, Attribute.INCLUDE);
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            Attribute attribute = Attribute.of(reader.getAttributeName(i));
            required.remove((Object)attribute);
            switch (attribute) {
                case PATTERN: {
                    pattern = this.propertyReplacer.replaceProperties(reader.getAttributeValue(i));
                    continue block4;
                }
                case INCLUDE: {
                    include = Boolean.parseBoolean(this.propertyReplacer.replaceProperties(reader.getAttributeValue(i)));
                    continue block4;
                }
                default: {
                    throw ParsingUtils.unexpectedContent(reader);
                }
            }
        }
        if (!required.isEmpty()) {
            throw ParsingUtils.missingAttributes(reader.getLocation(), required);
        }
        ParsingUtils.parseNoContent(reader);
        filters.add(new FileFilter(pattern, include));
    }

    static enum Attribute {
        UNKNOWN(null),
        PATTERN("pattern"),
        INCLUDE("include");

        private static final Map<String, Attribute> attributes;
        private final String name;

        static Attribute of(QName qName) {
            Attribute attribute = attributes.get(qName.getLocalPart());
            return attribute == null ? UNKNOWN : attribute;
        }

        private Attribute(String name) {
            this.name = name;
        }

        public String getLocalName() {
            return this.name;
        }

        static {
            HashMap<String, Attribute> attributesMap = new HashMap<String, Attribute>();
            attributesMap.put(PATTERN.getLocalName(), PATTERN);
            attributesMap.put(INCLUDE.getLocalName(), INCLUDE);
            attributes = attributesMap;
        }
    }
}

