/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.build.configassembly;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.wildfly.build.configassembly.ConfigurationAssembler;
import org.wildfly.build.configassembly.SubsystemConfig;
import org.wildfly.build.configassembly.SubsystemsParser;
import org.wildfly.build.util.BaseDirSubsystemInputStreamSources;
import org.wildfly.build.util.FileInputStreamSource;

public class StandaloneMain {
    public static void main(String[] args) throws Exception {
        File baseDir = new File(args[0]);
        if (!baseDir.exists() || !baseDir.isDirectory()) {
            throw new IllegalArgumentException("Base dir does not exist: " + baseDir.getAbsolutePath());
        }
        File templateFile = new File(args[1]);
        if (!templateFile.exists()) {
            throw new IllegalArgumentException("Template file does not exist: " + templateFile.getAbsolutePath());
        }
        File subsystemsFile = new File(args[2]);
        if (!subsystemsFile.exists()) {
            throw new IllegalArgumentException("Subsystems file does not exist " + subsystemsFile.getAbsolutePath());
        }
        File outputFile = new File(args[3]);
        BaseDirSubsystemInputStreamSources subsystemInputStreamSources = new BaseDirSubsystemInputStreamSources(baseDir.getAbsoluteFile());
        HashMap<String, Map<String, SubsystemConfig>> subsystems = new HashMap<String, Map<String, SubsystemConfig>>();
        SubsystemsParser.parse(new FileInputStreamSource(subsystemsFile), subsystems);
        ConfigurationAssembler assembler = new ConfigurationAssembler(subsystemInputStreamSources, new FileInputStreamSource(templateFile), "server", subsystems, outputFile);
        assembler.assemble();
    }
}

