/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.build.common.model;

import java.util.List;
import org.wildfly.build.common.model.CopyArtifact;
import org.wildfly.build.common.model.CopyArtifactsModelParser10;
import org.wildfly.build.common.model.FileFilter;
import org.wildfly.build.common.model.FileFilterXMLWriter10;
import org.wildfly.build.util.xml.AttributeValue;
import org.wildfly.build.util.xml.ElementNode;

public class CopyArtifactsXMLWriter10 {
    public static final CopyArtifactsXMLWriter10 INSTANCE = new CopyArtifactsXMLWriter10();

    private CopyArtifactsXMLWriter10() {
    }

    public void write(List<CopyArtifact> copyArtifacts, ElementNode parentElementNode) {
        if (!copyArtifacts.isEmpty()) {
            ElementNode artifactsElementNode = new ElementNode(parentElementNode, "copy-artifacts");
            for (CopyArtifact copyArtifact : copyArtifacts) {
                ElementNode copyArtifactElementNode = new ElementNode(parentElementNode, CopyArtifactsModelParser10.Element.COPY_ARTIFACT.getLocalName());
                this.writeCopyArtifact(copyArtifact, copyArtifactElementNode);
                artifactsElementNode.addChild(copyArtifactElementNode);
            }
            parentElementNode.addChild(artifactsElementNode);
        }
    }

    protected void writeCopyArtifact(CopyArtifact copyArtifact, ElementNode copyArtifactElementNode) {
        if (!copyArtifact.getFilters().isEmpty()) {
            for (FileFilter fileFilter : copyArtifact.getFilters()) {
                FileFilterXMLWriter10.INSTANCE.write(fileFilter, copyArtifactElementNode);
            }
        }
        copyArtifactElementNode.addAttribute(CopyArtifactsModelParser10.Attribute.ARTIFACT.getLocalName(), new AttributeValue(copyArtifact.getArtifact().toString()));
        copyArtifactElementNode.addAttribute(CopyArtifactsModelParser10.Attribute.TO_LOCATION.getLocalName(), new AttributeValue(copyArtifact.getToLocation()));
        if (copyArtifact.isExtract()) {
            copyArtifactElementNode.addAttribute(CopyArtifactsModelParser10.Attribute.EXTRACT.getLocalName(), new AttributeValue(Boolean.toString(copyArtifact.isExtract())));
        }
    }
}

