/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.build.configassembly;

import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.wildfly.build.configassembly.SubsystemConfig;
import org.wildfly.build.configassembly.SubsystemInputStreamSources;
import org.wildfly.build.configassembly.SubsystemParser;
import org.wildfly.build.configassembly.TemplateParser;
import org.wildfly.build.util.InputStreamSource;
import org.wildfly.build.util.xml.AttributeValue;
import org.wildfly.build.util.xml.ElementNode;
import org.wildfly.build.util.xml.FormattingXMLStreamWriter;
import org.wildfly.build.util.xml.Node;
import org.wildfly.build.util.xml.ProcessingInstructionNode;

public class ConfigurationAssembler {
    private final SubsystemInputStreamSources subsystemInputStreamSources;
    private final InputStreamSource templateInputStreamSource;
    private final String templateRootElementName;
    private final File outputFile;
    private final Map<String, Map<String, SubsystemConfig>> subsystemConfigs;

    public ConfigurationAssembler(SubsystemInputStreamSources subsystemInputStreamSources, InputStreamSource templateInputStreamSource, String templateRootElementName, Map<String, Map<String, SubsystemConfig>> subsystemConfigs, File outputFile) {
        this.subsystemInputStreamSources = subsystemInputStreamSources;
        this.templateInputStreamSource = templateInputStreamSource;
        this.templateRootElementName = templateRootElementName;
        this.subsystemConfigs = subsystemConfigs;
        this.outputFile = outputFile.getAbsoluteFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void assemble() throws IOException, XMLStreamException {
        TemplateParser templateParser = new TemplateParser(this.templateInputStreamSource, this.templateRootElementName);
        templateParser.parse();
        this.populateTemplate(templateParser, this.subsystemConfigs);
        if (this.outputFile.exists()) {
            this.outputFile.delete();
        }
        if (!this.outputFile.getParentFile().exists() && !this.outputFile.getParentFile().mkdirs()) {
            throw new IllegalStateException("Could not create " + this.outputFile.getParentFile());
        }
        FileWriter fileWriter = new FileWriter(this.outputFile);
        BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
        FormattingXMLStreamWriter writer = new FormattingXMLStreamWriter(XMLOutputFactory.newInstance().createXMLStreamWriter(bufferedWriter));
        try {
            writer.writeStartDocument();
            templateParser.getRootNode().marshall(writer);
            writer.writeEndDocument();
        }
        finally {
            this.safeClose(writer);
            this.safeClose(bufferedWriter);
            this.safeClose(fileWriter);
        }
    }

    private void safeClose(Closeable c) {
        try {
            c.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void safeClose(XMLStreamWriter c) {
        try {
            c.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void populateTemplate(TemplateParser templateParser, Map<String, Map<String, SubsystemConfig>> subsystemsConfigs) throws IOException, XMLStreamException {
        Node node;
        TreeSet<String> extensions = new TreeSet<String>();
        HashMap<String, Map<String, ElementNode>> socketBindingsByGroup = new HashMap<String, Map<String, ElementNode>>();
        HashMap<String, Map<String, ElementNode>> outboundSocketBindingsByGroup = new HashMap<String, Map<String, ElementNode>>();
        TreeMap<String, ElementNode> interfaces = new TreeMap<String, ElementNode>();
        for (Map.Entry<String, ProcessingInstructionNode> entry : templateParser.getSubsystemPlaceholders().entrySet()) {
            String profileName = entry.getKey();
            String groupName = entry.getValue().getDataValue("socket-binding-group", "");
            Map<String, SubsystemConfig> subsystems = subsystemsConfigs.get(profileName);
            if (subsystems == null) {
                throw new IllegalStateException("Could not find a subsystems configuration called '" + entry.getKey());
            }
            TreeMap<String, ElementNode> socketBindings = new TreeMap<String, ElementNode>();
            if (socketBindingsByGroup.put(groupName, socketBindings) != null) {
                throw new IllegalStateException("Group '" + groupName + "' already exists");
            }
            TreeMap<String, ElementNode> outboundSocketBindings = new TreeMap<String, ElementNode>();
            outboundSocketBindingsByGroup.put(groupName, outboundSocketBindings);
            for (SubsystemConfig subsystem : subsystems.values()) {
                InputStreamSource inputStreamSource = this.subsystemInputStreamSources.getInputStreamSource(subsystem.getSubsystem());
                if (inputStreamSource == null) {
                    throw new IllegalStateException("Could not resolve '" + subsystem + " Check the module for the extension has been defined.");
                }
                SubsystemParser subsystemParser = new SubsystemParser(templateParser.getRootNode().getNamespace(), subsystem.getSupplement(), inputStreamSource);
                subsystemParser.parse();
                entry.getValue().addDelegate(subsystemParser.getSubsystem());
                extensions.add(subsystemParser.getExtensionModule());
                for (Map.Entry<String, ElementNode> entry2 : subsystemParser.getSocketBindings().entrySet()) {
                    if (socketBindings.containsKey(entry2.getKey())) {
                        throw new IllegalStateException("SocketBinding '" + entry2 + "' already exists");
                    }
                    socketBindings.put(entry2.getKey(), entry2.getValue());
                }
                for (Map.Entry<String, ElementNode> entry2 : subsystemParser.getOutboundSocketBindings().entrySet()) {
                    if (outboundSocketBindings.containsKey(entry2.getKey())) {
                        throw new IllegalStateException("Outbound SocketBinding '" + entry2 + "' already exists");
                    }
                    outboundSocketBindings.put(entry2.getKey(), entry2.getValue());
                }
                for (Map.Entry<String, ElementNode> entry2 : subsystemParser.getInterfaces().entrySet()) {
                    interfaces.put(entry2.getKey(), entry2.getValue());
                }
            }
        }
        if (extensions.size() > 0) {
            ProcessingInstructionNode extensionNode = templateParser.getExtensionPlaceHolder();
            for (String extension : extensions) {
                ElementNode extensionElement = new ElementNode(null, "extension", templateParser.getRootNode().getNamespace());
                extensionElement.addAttribute("module", new AttributeValue(extension));
                extensionNode.addDelegate(extensionElement);
            }
        } else {
            Iterator<Node> it2 = templateParser.getRootNode().iterateChildren();
            while (it2.hasNext()) {
                ElementNode elementNode;
                Node node2 = it2.next();
                if (!(node2 instanceof ElementNode) || !(elementNode = (ElementNode)node2).getName().equals("extensions") && !elementNode.getName().equals("profile")) continue;
                it2.remove();
            }
        }
        if (socketBindingsByGroup.size() > 0 && outboundSocketBindingsByGroup.size() > 0) {
            ElementNode socketGroupsParent = ConfigurationAssembler.findElementNode(templateParser.getRootNode(), "socket-binding-groups", false);
            if (socketGroupsParent != null) {
                Iterator<Node> iterator = socketGroupsParent.iterateChildren();
                while (iterator.hasNext()) {
                    node = iterator.next();
                    if (!(node instanceof ElementNode)) continue;
                    ElementNode groupNode = (ElementNode)node;
                    this.integrateTemplateBindings(templateParser, socketBindingsByGroup, outboundSocketBindingsByGroup, groupNode);
                }
            } else {
                ElementNode elementNode = ConfigurationAssembler.findElementNode(templateParser.getRootNode(), "socket-binding-group", false);
                if (elementNode != null) {
                    this.integrateTemplateBindings(templateParser, socketBindingsByGroup, outboundSocketBindingsByGroup, elementNode);
                }
            }
            for (Map.Entry<String, ProcessingInstructionNode> entry : templateParser.getSocketBindingsPlaceHolders().entrySet()) {
                Map socketBindings = (Map)socketBindingsByGroup.get(entry.getKey());
                if (socketBindings == null) {
                    throw new IllegalArgumentException("No socket bindings for group " + entry.getKey());
                }
                if (socketBindings.size() <= 0) continue;
                for (ElementNode binding : socketBindings.values()) {
                    entry.getValue().addDelegate(binding);
                }
            }
            for (Map.Entry<String, ProcessingInstructionNode> entry : templateParser.getSocketBindingsPlaceHolders().entrySet()) {
                Map outboundSocketBindings = (Map)outboundSocketBindingsByGroup.get(entry.getKey());
                if (outboundSocketBindings == null) {
                    throw new IllegalArgumentException("No outbound socket bindings for group " + entry.getKey());
                }
                if (outboundSocketBindings.size() <= 0) continue;
                for (ElementNode binding : outboundSocketBindings.values()) {
                    entry.getValue().addDelegate(binding);
                }
            }
        }
        if (interfaces.size() > 0) {
            ElementNode interfacesParent = ConfigurationAssembler.findElementNode(templateParser.getRootNode(), "interfaces", true);
            assert (interfacesParent != null);
            Iterator<Node> iterator = interfacesParent.iterateChildren();
            while (iterator.hasNext()) {
                node = iterator.next();
                if (!(node instanceof ElementNode)) continue;
                ElementNode elementNode = (ElementNode)node;
                interfaces.putIfAbsent(elementNode.getAttributeValue("name"), elementNode);
                iterator.remove();
            }
            ProcessingInstructionNode processingInstructionNode = templateParser.getInterfacesPlaceHolders();
            for (ElementNode interfaceElement : interfaces.values()) {
                processingInstructionNode.addDelegate(interfaceElement);
            }
        }
    }

    private void integrateTemplateBindings(TemplateParser templateParser, Map<String, Map<String, ElementNode>> socketBindingsByGroup, Map<String, Map<String, ElementNode>> outboundSocketBindingsByGroup, ElementNode groupNode) {
        String groupName = groupNode.getAttributeValue("name");
        if (templateParser.getSocketBindingsPlaceHolders().containsKey(groupName)) {
            Map<String, ElementNode> inboundMap = socketBindingsByGroup.get(groupName);
            Map<String, ElementNode> outboundMap = outboundSocketBindingsByGroup.get(groupName);
            Iterator<Node> groupit = groupNode.iterateChildren();
            while (groupit.hasNext()) {
                Node bnode = groupit.next();
                if (!(bnode instanceof ElementNode)) continue;
                ElementNode bindingNode = (ElementNode)bnode;
                if (inboundMap != null && bindingNode.getName().equals("socket-binding")) {
                    inboundMap.putIfAbsent(bindingNode.getAttributeValue("name"), bindingNode);
                    groupit.remove();
                    continue;
                }
                if (outboundMap == null || !bindingNode.getName().equals("outbound-socket-binding")) continue;
                outboundMap.putIfAbsent(bindingNode.getAttributeValue("name"), bindingNode);
                groupit.remove();
            }
        }
    }

    private static ElementNode findElementNode(ElementNode parent, String name, boolean required) {
        Iterator<Node> it = parent.iterateChildren();
        while (it.hasNext()) {
            ElementNode elementNode;
            Node node = it.next();
            if (!(node instanceof ElementNode) || !(elementNode = (ElementNode)node).getName().equals(name)) continue;
            return elementNode;
        }
        if (required) {
            throw new IllegalStateException("Node " + parent.getName() + " has no children named " + name);
        }
        return null;
    }
}

