/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.build.util;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Enumeration;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class FileUtils {
    public static void extractFile(JarFile jarFile, String jarEntryName, File targetFile) throws IOException {
        byte[] data = new byte[1024];
        ZipEntry entry = jarFile.getEntry(jarEntryName);
        if (entry.isDirectory()) {
            targetFile.mkdirs();
            return;
        }
        File parent = targetFile.getParentFile();
        if (!parent.exists()) {
            parent.mkdirs();
        }
        try (FileOutputStream fos = new FileOutputStream(targetFile);
             InputStream is = jarFile.getInputStream(entry);){
            int read;
            while ((read = is.read(data)) > 0) {
                fos.write(data, 0, read);
            }
        }
    }

    public static void extractSchemas(File file, File outputDirectory) throws IOException {
        block23: {
            try (ZipFile zip = new ZipFile(file);){
                if (zip.getEntry("schema") == null) break block23;
                Enumeration<? extends ZipEntry> entries = zip.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry entry = entries.nextElement();
                    if (entry.isDirectory()) continue;
                    String entryName = entry.getName();
                    if (outputDirectory == null || !entryName.startsWith("schema/")) continue;
                    InputStream in = zip.getInputStream(entry);
                    Throwable throwable = null;
                    try {
                        FileUtils.copyFile(in, new File(outputDirectory, entryName.substring("schema/".length())));
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (in == null) continue;
                        if (throwable != null) {
                            try {
                                in.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        in.close();
                    }
                }
            }
        }
    }

    public static void copyFile(InputStream in, File dest) throws IOException {
        dest.getParentFile().mkdirs();
        Files.copy(in, dest.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    public static void copyFile(File src, File dest) throws IOException {
        Files.copy(src.toPath(), dest.toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    public static String readFile(File file) {
        try {
            return FileUtils.readFile(new FileInputStream(file));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readFile(InputStream file) {
        try (BufferedInputStream stream = new BufferedInputStream(file);){
            byte[] buff = new byte[1024];
            StringBuilder builder = new StringBuilder();
            int read = -1;
            while ((read = stream.read(buff)) != -1) {
                builder.append(new String(buff, 0, read));
            }
            String string = builder.toString();
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void deleteRecursive(File file) {
        File[] files = file.listFiles();
        if (files != null) {
            for (File f : files) {
                FileUtils.deleteRecursive(f);
            }
        }
        file.delete();
    }
}

