/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.build.util;

import java.util.ArrayList;
import java.util.List;
import nu.xom.Attribute;
import nu.xom.Document;
import org.wildfly.build.pack.model.Artifact;
import org.wildfly.build.pack.model.ModuleIdentifier;

public class ModuleParseResult {
    final List<ModuleDependency> dependencies = new ArrayList<ModuleDependency>();
    final List<String> resourceRoots = new ArrayList<String>();
    final List<ArtifactName> artifacts = new ArrayList<ArtifactName>();
    final Document document;
    ModuleIdentifier identifier;
    ArtifactName versionArtifactName;

    public ModuleParseResult(Document document) {
        this.document = document;
    }

    public List<ModuleDependency> getDependencies() {
        return this.dependencies;
    }

    public List<String> getResourceRoots() {
        return this.resourceRoots;
    }

    public List<ArtifactName> getArtifacts() {
        return this.artifacts;
    }

    public ModuleIdentifier getIdentifier() {
        return this.identifier;
    }

    public Document getDocument() {
        return this.document;
    }

    public ArtifactName getVersionArtifactName() {
        return this.versionArtifactName;
    }

    public static class ArtifactName {
        private final String artifactCoords;
        private final String options;
        private final Attribute attribute;

        public ArtifactName(String artifactCoords, String options, Attribute attribute) {
            this.artifactCoords = artifactCoords;
            this.options = options;
            this.attribute = attribute;
        }

        public String getArtifactCoords() {
            return this.artifactCoords;
        }

        public String getOptions() {
            return this.options;
        }

        public Attribute getAttribute() {
            return this.attribute;
        }

        public String getJBossModulesArtifactString() {
            Artifact artifact = this.getArtifact();
            if (artifact.getVersion() == null) {
                throw new IllegalStateException("getJBossModulesArtifactString can only be called for versioned artifacts");
            }
            if (artifact.getPackaging() != null) {
                throw new IllegalStateException("getJBossModulesArtifactString can only be called for jar artifacts");
            }
            if (artifact.getClassifier() == null) {
                return artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion();
            }
            return artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion() + ":" + artifact.getClassifier();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(this.artifactCoords);
            if (this.options != null) {
                sb.append('?').append(this.options);
            }
            return sb.toString();
        }

        public boolean hasVersion() {
            return this.getArtifact().getVersion() != null;
        }

        public Artifact getArtifact() {
            return Artifact.parse(this.getArtifactCoords());
        }
    }

    public static class ModuleDependency {
        private final ModuleIdentifier moduleId;
        private final boolean optional;

        public ModuleDependency(ModuleIdentifier moduleId, boolean optional) {
            this.moduleId = moduleId;
            this.optional = optional;
        }

        public ModuleIdentifier getModuleId() {
            return this.moduleId;
        }

        public boolean isOptional() {
            return this.optional;
        }

        public String toString() {
            return "[" + this.moduleId + (this.optional ? ",optional=true" : "") + "]";
        }
    }
}

