/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.compatibility;

import java.io.InputStream;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.osgi.StartLevelAware;
import org.jboss.gravia.resource.Resource;
import org.jboss.gravia.runtime.Module;
import org.jboss.gravia.runtime.ModuleContext;
import org.jboss.gravia.runtime.Runtime;
import org.jboss.gravia.runtime.RuntimeLocator;
import org.jboss.gravia.runtime.ServiceReference;
import org.jboss.osgi.metadata.OSGiManifestBuilder;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.osgi.service.log.LogService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Arquillian.class)
public class LogServiceTest {
    @Deployment
    @StartLevelAware(autostart=true)
    public static JavaArchive deployment() {
        final JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"logging-test.jar");
        archive.addClasses(new Class[]{LogServiceTest.class});
        archive.setManifest(new Asset(){

            public InputStream openStream() {
                OSGiManifestBuilder builder = OSGiManifestBuilder.newInstance();
                builder.addBundleManifestVersion(2);
                builder.addBundleSymbolicName(archive.getName());
                builder.addBundleVersion("1.0.0");
                builder.addImportPackages(new Class[]{RuntimeLocator.class, LogService.class, LoggerFactory.class, Resource.class});
                return builder.openStream();
            }
        });
        return archive;
    }

    @Test
    public void testLogService() throws Exception {
        Runtime runtime = RuntimeLocator.getRequiredRuntime();
        Module module = runtime.getModule(this.getClass().getClassLoader());
        LogService log = this.getLogService(module.getModuleContext());
        String msg = "LogServiceTest LogService ";
        log.log(1, msg + " ERROR");
        log.log(2, msg + " WARNING");
        log.log(3, msg + " INFO");
        log.log(4, msg + " DEBUG");
    }

    @Test
    public void testSLF4J() throws Exception {
        Logger logsrv = LoggerFactory.getLogger(LogServiceTest.class);
        String msg = "LogServiceTest SLF4J ";
        logsrv.error(msg + " ERROR");
        logsrv.warn(msg + " WARN");
        logsrv.info(msg + " INFO");
        logsrv.debug(msg + " DEBUG");
    }

    private LogService getLogService(ModuleContext context) {
        ServiceReference sref = context.getServiceReference(LogService.class);
        Assert.assertNotNull((String)"LogService not null", (Object)sref);
        return (LogService)context.getService(sref);
    }
}

