/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.compatibility;

import java.io.InputStream;
import java.util.concurrent.TimeUnit;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.osgi.metadata.OSGiManifestBuilder;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.EmptyAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.wildfly.camel.test.compatibility.subB.MyRoutes;
import org.wildfly.camel.test.compatibility.subB.SomeBean;

@RunWith(value=Arquillian.class)
public class CDIIntegrationTest {
    @Deployment
    public static JavaArchive createdeployment() {
        final JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"cdi-tests.jar");
        archive.addClasses(new Class[]{MyRoutes.class, SomeBean.class});
        archive.addAsManifestResource((Asset)EmptyAsset.INSTANCE, "beans.xml");
        archive.setManifest(new Asset(){

            public InputStream openStream() {
                OSGiManifestBuilder builder = OSGiManifestBuilder.newInstance();
                builder.addBundleManifestVersion(2);
                builder.addBundleSymbolicName(archive.getName());
                builder.addBundleVersion("1.0.0");
                return builder.openStream();
            }
        });
        return archive;
    }

    @Test
    public void testCDIRoute() throws Exception {
        boolean result = SomeBean.latch.await(3L, TimeUnit.SECONDS);
        Assert.assertTrue((String)"Countdown reached", (boolean)result);
    }
}

