/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.compatibility;

import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.osgi.StartLevelAware;
import org.jboss.gravia.resource.Resource;
import org.jboss.gravia.runtime.Module;
import org.jboss.gravia.runtime.ModuleContext;
import org.jboss.gravia.runtime.Runtime;
import org.jboss.gravia.runtime.RuntimeLocator;
import org.jboss.gravia.runtime.RuntimeType;
import org.jboss.gravia.runtime.ServiceEvent;
import org.jboss.gravia.runtime.ServiceListener;
import org.jboss.gravia.runtime.ServiceReference;
import org.jboss.osgi.metadata.OSGiManifestBuilder;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.osgi.service.component.ComponentContext;
import org.wildfly.camel.test.compatibility.subA.ServiceA;
import org.wildfly.camel.test.compatibility.subA.ServiceA1;

@RunWith(value=Arquillian.class)
public class ServiceComponentTest {
    @Deployment
    @StartLevelAware(autostart=true)
    public static Archive<?> deployment() {
        final JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"scr-test.jar");
        archive.addClasses(new Class[]{ServiceA.class, ServiceA1.class});
        archive.addAsResource("OSGI-INF/org.wildfly.camel.test.compatibility.subA.ServiceA.xml");
        archive.addAsResource("OSGI-INF/org.wildfly.camel.test.compatibility.subA.ServiceA1.xml");
        archive.setManifest(new Asset(){

            public InputStream openStream() {
                OSGiManifestBuilder builder = OSGiManifestBuilder.newInstance();
                builder.addBundleManifestVersion(2);
                builder.addBundleSymbolicName(archive.getName());
                builder.addBundleVersion("1.0.0");
                builder.addImportPackages(new Class[]{RuntimeLocator.class, ComponentContext.class, Resource.class});
                builder.addManifestHeader("Service-Component", "OSGI-INF/org.wildfly.camel.test.compatibility.subA.ServiceA.xml,OSGI-INF/org.wildfly.camel.test.compatibility.subA.ServiceA1.xml");
                return builder.openStream();
            }
        });
        return archive;
    }

    @Test
    public void testServiceAvailability() throws Exception {
        Runtime runtime = RuntimeLocator.getRequiredRuntime();
        Module modA = runtime.getModule(this.getClass().getClassLoader());
        if (RuntimeType.getRuntimeType((Runtime)runtime) == RuntimeType.WILDFLY) {
            System.out.println(Module.class.getClassLoader().loadClass(ComponentContext.class.getName()).getClassLoader());
            System.out.println(ComponentContext.class.getClassLoader());
        }
        ModuleContext ctxA = modA.getModuleContext();
        ServiceReference srefA = ctxA.getServiceReference(ServiceA.class);
        Assert.assertNotNull((String)"ServiceReference not null", (Object)srefA);
        ServiceA srvA = (ServiceA)ctxA.getService(srefA);
        Assert.assertEquals((Object)"ServiceA#1:ServiceA1#1:Hello", (Object)srvA.doStuff("Hello"));
        this.assertDisableComponent(ctxA, srvA);
    }

    private void assertDisableComponent(final ModuleContext ctxA, ServiceA srvA) throws InterruptedException {
        final CountDownLatch latch = new CountDownLatch(1);
        ServiceListener listener = new ServiceListener(){

            public void serviceChanged(ServiceEvent event) {
                int type = event.getType();
                ServiceReference sref = event.getServiceReference();
                List<String> clazzes = Arrays.asList((String[])sref.getProperty("objectClass"));
                if (type == 4 && clazzes.contains(ServiceA1.class.getName())) {
                    ctxA.removeServiceListener((ServiceListener)this);
                    latch.countDown();
                }
            }
        };
        ctxA.addServiceListener(listener);
        ComponentContext ccA1 = srvA.getServiceA1().getComponentContext();
        ccA1.disableComponent(ServiceA1.class.getName());
        Assert.assertTrue((boolean)latch.await(2L, TimeUnit.SECONDS));
        ServiceReference srefA = ctxA.getServiceReference(ServiceA.class);
        Assert.assertNull((String)"ServiceReference null", (Object)srefA);
        ServiceReference srefA1 = ctxA.getServiceReference(ServiceA1.class);
        Assert.assertNull((String)"ServiceReference null", (Object)srefA1);
    }
}

