/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.camel.test.compatibility;

import java.io.InputStream;
import java.net.URL;
import org.apache.camel.CamelContext;
import org.apache.camel.ProducerTemplate;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.camel.spring.handler.CamelNamespaceHandler;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.gravia.resource.Resource;
import org.jboss.gravia.runtime.RuntimeLocator;
import org.jboss.osgi.metadata.OSGiManifestBuilder;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.UrlResource;
import org.wildfly.camel.test.compatibility.subA.HelloBean;
import org.wildfly.extension.camel.CamelAware;
import org.wildfly.extension.camel.SpringCamelContextFactory;
import org.xml.sax.EntityResolver;

@CamelAware
@RunWith(value=Arquillian.class)
public class SpringBeanTransformTest {
    @Deployment
    public static JavaArchive createdeployment() {
        final JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"camel-spring-tests.jar");
        archive.addClasses(new Class[]{HelloBean.class, SpringCamelContextFactory.class});
        archive.addAsResource("spring/bean-transform-camel-context.xml", "some-other-name.xml");
        archive.setManifest(new Asset(){

            public InputStream openStream() {
                OSGiManifestBuilder builder = OSGiManifestBuilder.newInstance();
                builder.addBundleManifestVersion(2);
                builder.addBundleSymbolicName(archive.getName());
                builder.addBundleVersion("1.0.0");
                builder.addImportPackages(new Class[]{RuntimeLocator.class, Resource.class, CamelContext.class, SpringCamelContext.class, CamelNamespaceHandler.class});
                builder.addImportPackages(new Class[]{UrlResource.class, BeanDefinitionRegistry.class, XmlBeanDefinitionReader.class, GenericApplicationContext.class});
                builder.addImportPackages(new Class[]{EntityResolver.class});
                return builder.openStream();
            }
        });
        return archive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSpringContextFromURL() throws Exception {
        URL resourceUrl = this.getClass().getResource("/some-other-name.xml");
        SpringCamelContext camelctx = SpringCamelContextFactory.createSingleCamelContext((URL)resourceUrl, (ClassLoader)this.getClass().getClassLoader());
        camelctx.start();
        try {
            ProducerTemplate producer = camelctx.createProducerTemplate();
            String result = (String)producer.requestBody("direct:start", (Object)"Kermit", String.class);
            Assert.assertEquals((Object)"Hello Kermit", (Object)result);
        }
        finally {
            camelctx.stop();
        }
    }
}

