/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl;

import java.io.PrintStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.felix.scr.impl.BundleComponentActivator;
import org.apache.felix.scr.impl.ComponentActorThread;
import org.apache.felix.scr.impl.ComponentRegistry;
import org.apache.felix.scr.impl.ScrCommand;
import org.apache.felix.scr.impl.config.ScrConfiguration;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.service.log.LogService;
import org.osgi.util.tracker.ServiceTracker;

public class Activator
implements BundleActivator,
SynchronousBundleListener {
    static final String LOGSERVICE_CLASS = "org.osgi.service.log.LogService";
    static final String PACKAGEADMIN_CLASS = "org.osgi.service.packageadmin.PackageAdmin";
    private static ScrConfiguration m_configuration = new ScrConfiguration();
    private static BundleContext m_context;
    private static ServiceTracker m_logService;
    private static ServiceTracker m_packageAdmin;
    private Map m_componentBundles;
    private ComponentRegistry m_componentRegistry;
    private ComponentActorThread m_componentActor;

    public void start(BundleContext context) throws Exception {
        m_context = context;
        m_logService = new ServiceTracker(context, LOGSERVICE_CLASS, null);
        m_logService.open();
        this.m_componentBundles = new HashMap();
        this.m_componentRegistry = new ComponentRegistry(context);
        m_configuration.start(context);
        Activator.log(3, context.getBundle(), " Version = " + (String)context.getBundle().getHeaders().get("Bundle-Version"), null);
        this.m_componentActor = new ComponentActorThread();
        Thread t = new Thread((Runnable)this.m_componentActor, "SCR Component Actor");
        t.setDaemon(true);
        t.start();
        context.addBundleListener((BundleListener)this);
        this.loadAllComponents(context);
        ScrCommand.register(context, this.m_componentRegistry, m_configuration);
    }

    public void stop(BundleContext context) throws Exception {
        context.removeBundleListener((BundleListener)this);
        this.disposeAllComponents();
        this.m_componentRegistry.dispose();
        if (this.m_componentActor != null) {
            this.m_componentActor.terminate();
            this.m_componentActor = null;
        }
        if (m_logService != null) {
            m_logService.close();
            m_logService = null;
        }
        if (m_packageAdmin != null) {
            m_packageAdmin.close();
            m_packageAdmin = null;
        }
        m_context = null;
    }

    public void bundleChanged(BundleEvent event) {
        if (event.getType() == 512 || event.getType() == 2) {
            this.loadComponents(event.getBundle());
        } else if (event.getType() == 256) {
            this.disposeComponents(event.getBundle());
        }
    }

    private void loadAllComponents(BundleContext context) {
        Bundle[] bundles = context.getBundles();
        for (int i = 0; i < bundles.length; ++i) {
            Bundle bundle = bundles[i];
            if (!ComponentRegistry.isBundleActive(bundle)) continue;
            this.loadComponents(bundle);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadComponents(Bundle bundle) {
        boolean loaded;
        if (bundle.getHeaders().get("Service-Component") == null) {
            return;
        }
        BundleContext context = bundle.getBundleContext();
        if (context == null) {
            Activator.log(1, m_context.getBundle(), "Cannot get BundleContext of bundle " + bundle.getSymbolicName() + "/" + bundle.getBundleId(), null);
            return;
        }
        Long bundleId = new Long(bundle.getBundleId());
        Map map = this.m_componentBundles;
        synchronized (map) {
            if (this.m_componentBundles.containsKey(bundleId)) {
                loaded = true;
            } else {
                this.m_componentBundles.put(bundleId, bundleId);
                loaded = false;
            }
        }
        if (loaded) {
            Activator.log(4, m_context.getBundle(), "Components for bundle  " + bundle.getSymbolicName() + "/" + bundle.getBundleId() + " already loaded. Nothing to do.", null);
            return;
        }
        try {
            BundleComponentActivator ga = new BundleComponentActivator(this.m_componentRegistry, this.m_componentActor, context, m_configuration);
            Map map2 = this.m_componentBundles;
            synchronized (map2) {
                this.m_componentBundles.put(bundleId, ga);
            }
        }
        catch (Exception e) {
            Map map3 = this.m_componentBundles;
            synchronized (map3) {
                this.m_componentBundles.remove(bundleId);
            }
            if (e instanceof IllegalStateException && bundle.getState() != 32) {
                Activator.log(4, m_context.getBundle(), "Bundle " + bundle.getSymbolicName() + "/" + bundle.getBundleId() + " has been stopped while trying to activate its components. Trying again when the bundles gets startet again.", e);
            }
            Activator.log(1, m_context.getBundle(), "Error while loading components of bundle " + bundle.getSymbolicName() + "/" + bundle.getBundleId(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disposeComponents(Bundle bundle) {
        Object ga;
        Map map = this.m_componentBundles;
        synchronized (map) {
            ga = this.m_componentBundles.remove(new Long(bundle.getBundleId()));
        }
        if (ga instanceof BundleComponentActivator) {
            try {
                ((BundleComponentActivator)ga).dispose(6);
            }
            catch (Exception e) {
                Activator.log(1, m_context.getBundle(), "Error while disposing components of bundle " + bundle.getSymbolicName() + "/" + bundle.getBundleId(), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disposeAllComponents() {
        Object[] activators;
        Map map = this.m_componentBundles;
        synchronized (map) {
            activators = this.m_componentBundles.values().toArray();
            this.m_componentBundles.clear();
        }
        for (int i = 0; i < activators.length; ++i) {
            if (!(activators[i] instanceof BundleComponentActivator)) continue;
            BundleComponentActivator ga = (BundleComponentActivator)activators[i];
            try {
                Bundle bundle = ga.getBundleContext().getBundle();
                try {
                    ga.dispose(5);
                }
                catch (Exception e) {
                    Activator.log(1, m_context.getBundle(), "Error while disposing components of bundle " + bundle.getSymbolicName() + "/" + bundle.getBundleId(), e);
                }
                continue;
            }
            catch (IllegalStateException e) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void log(int level, Bundle bundle, String message, Throwable ex) {
        if (m_configuration.getLogLevel() >= level) {
            Object logger;
            ServiceTracker t = m_logService;
            Object v0 = logger = t != null ? t.getService() : null;
            if (logger == null) {
                PrintStream out = level == 1 ? System.err : System.out;
                StringBuffer buf = new StringBuffer();
                switch (level) {
                    case 4: {
                        buf.append("DEBUG: ");
                        break;
                    }
                    case 3: {
                        buf.append("INFO : ");
                        break;
                    }
                    case 2: {
                        buf.append("WARN : ");
                        break;
                    }
                    case 1: {
                        buf.append("ERROR: ");
                        break;
                    }
                    default: {
                        buf.append("UNK  : ");
                    }
                }
                if (bundle != null) {
                    buf.append(bundle.getSymbolicName());
                    buf.append(" (");
                    buf.append(bundle.getBundleId());
                    buf.append("): ");
                }
                buf.append(message);
                PrintStream printStream = out;
                synchronized (printStream) {
                    out.println(buf);
                    if (ex != null) {
                        ex.printStackTrace(out);
                    }
                }
            } else {
                ((LogService)logger).log(level, message, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object getPackageAdmin() {
        if (m_packageAdmin != null) return m_packageAdmin.getService();
        Class<Activator> clazz = Activator.class;
        synchronized (Activator.class) {
            if (m_packageAdmin != null) return m_packageAdmin.getService();
            m_packageAdmin = new ServiceTracker(m_context, PACKAGEADMIN_CLASS, null);
            m_packageAdmin.open();
            // ** MonitorExit[var0] (shouldn't be in output)
            return m_packageAdmin.getService();
        }
    }
}

